/*
 * ParallelFetchData.c
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif


#if defined(_PARALLEL_) && defined(_HAVE_PETSC_)

#include "./io.h"
#include "../include/macros.h"
#include "../shared/shared.h"


#undef __FUNCT__
#define __FUNCT__ "ParallelFetchData"

void ParallelFetchData(void** pdata,int* pM,int* pN,FILE* fid, char* data_type,char* sub_data_type){

	/*Branch according to data type and sub_data_type: */
	if (strcmp(data_type,"Matrix")==0){

		if (strcmp(sub_data_type,"Mat")==0){
			ParallelFetchMat((double**)pdata,pM,pN,fid);
		}
		else throw ErrorException(__FUNCT__,exprintf("%s%s%s%s%s"," sub_data_type ",sub_data_type," for ",data_type," type not supported yet!"));
	}
	else if (strcmp(data_type,"String")==0){

		/*Call ParallelFetchString: */
		ParallelFetchString((char**)pdata,fid);


	}
	else if (strcmp(data_type,"Scalar")==0){

		/*Call ParallelFetchScalar. Cast pdata from a (void**) to a (double*), because we are not going to allocate a scalar,
		 *just dereference the double*.: */
		ParallelFetchScalar((double*)pdata,fid);

	}
	else if (strcmp(data_type,"Integer")==0){

		/*Call ParallelFetchInteger. Cast pdata from a (void**) to a (int*), because we are not going to allocate an integer,
		 *just dereference the int*.: */
		ParallelFetchInteger((int*)pdata,fid);
	
	}
	else throw ErrorException(__FUNCT__,exprintf("%s%s%s"," data_type ",data_type," not supported yet!"));
}

#endif //#if defined(_PARALLEL_) && defined(_HAVE_PETSC_)

