/*  _________________________________________________________________________
 *
 *  Coliny: A Library of COLIN optimizers
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top Coliny directory.
 *  _________________________________________________________________________
 */


//
// PEAint.cpp
//

#include <acro_config.h>
#include <coliny/PEAint.h>

namespace coliny {


PEAint::PEAint() 
  : EAbase<EApoint_array<int>, BasicArray<int> >(),
    EAops_intarray(),
    PEAbase<EApoint_array<int>, BasicArray<int> >()
{ }


void PEAreal::write(ostream& os) const
{
PEAbase<EApoint_array<int>, BasicArray<int> >::write(os);
EAops_real::write(os);
}


void PEAreal::reset() 
{
if (popsize() == 0)
   init_population(100);
PEAbase<EApoint_array<int>, BasicArray<int> >::reset(); 
EAops_intarray::reset(); 
}

} // namespace coliny
