
/*
   ParallelFetchInteger.c
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "../toolkits/toolkits.h"
#include "../shared/shared.h"

#if defined(_PARALLEL_) && defined(_HAVE_PETSC_)

#undef __FUNCT__
#define __FUNCT__ "ParallelFetchInteger"
void ParallelFetchInteger(int* pinteger,FILE* fid){

	/*error management*/
	extern int my_rank;
	extern int num_procs;

	/*output: */
	int   integer;

	/*We have to read a integer from disk. First read the dimensions of the integer, then the integer: */
	if(my_rank==0){  
		if(fread(&integer,sizeof(int),1,fid)!=1) throw ErrorException(__FUNCT__," could not read integer ");
	}

	MPI_Bcast(&integer,1,MPI_INT,0,MPI_COMM_WORLD); 

	/*Assign output pointers: */
	*pinteger=integer;

}

#endif //#if defined(_PARALLEL_) && defined(_HAVE_PETSC_)
