function Ke=CreateKMatrix(singelem,grids,materials,inputs,analysis_type)
%CREATEKMATRIX - create the stiffmess matrix for singelem
%
%   this stiffness matrix works for Hutter's model
%
%   Usage:
%      Ke=CreateKMatrix(singelem,grids,materials,inputs,analysis_type)
%
%   See also CREATEPVECTOR


	if strcmpi(analysis_type,'diagnostic_hutter'),

		Ke=CreateKMatrixHutter(singelem,grids,materials,inputs);

	else
		error('CreateKMatrix/beam error message: analysis type not supported yet')
	end
end %end function

function Ke=CreateKMatrixHutter(singelem,grids,materials,inputs)

	%some variables
	numgrids=1;
	DOFPERGRID=2;
	numdof=numgrids*DOFPERGRID; %number of dof for element singelem.

	%Create elementary stiffness matrix 
	Ke=elemmatrix(numdof);

	%Build linear indices for elementary stiffness matrix.
	for i=1:numgrids,
		doflist=grids(singelem.g(i)).grid.doflist; %list of dofs in the g-set
		for j=1:DOFPERGRID,
			dof=doflist(j);
			Ke.row_indices((i-1)*DOFPERGRID+j)=dof;
		end
		
		dof=doflist(1);
	end

	Ke.terms=eye(2);

end %end function
