function plot_highlightelements(md,options_structure,width,i);
%PLOT_HIGHLIGHTELEMENTS - plot selected elements
%
%   Usage:
%      plot_highlightelements(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%plot mesh boundaries
subplot(width,width,i); 

%process data and model
[x y z elements is2d]=processmesh(md,options_structure);
[elementnumbers isgrid]=processdata(md,[1:md.numberofelements]',options_structure);

%plot
if is2d
	%plot mesh 
	A=elements(:,1); B=elements(:,2); C=elements(:,3);
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	for i=1:size(elements,1),
		if ~isnan(options_structure.highlight) & ismember(elementnumbers(i),options_structure.highlight)
			A=elements(i,1); B=elements(i,2);  C=elements(i,3);
			patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
		end
	end
else
	%plot mesh 
	A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	for i=1:size(elements,1),
		if ~isnan(options_structure.highlight) & ismember(elementnumbers(i),options_structure.highlight)
			A=elements(i,1); B=elements(i,2);  C=elements(i,3);  D=elements(i,4); E=elements(i,5);  F=elements(i,6);
			patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
			patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
			patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
			patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
			patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
		end
	end
end

%apply options
if isnan(options_structure.highlight)
	disp('highlightelements warning : highlight option empty, not element highlighted');
end
if isnan(options_structure.title)
	options_structure.title='Highlighted Elements';
end
if isnan(options_structure.colorbar)
	options_structure.colorbar=0;
end
applyoptions(md,[],options_structure);
