function usenamespace(package)
%USENAMESPACE- switch between packages for solution routines
%
%   To avoid having to rename the routines for solution sequences (depending 
%   on if we are running the macyeal, ice or cielo routines), we can switch 
%   packages routines on and off by just using their corresponding name space. 
%   For example: usenamespace('ice') will take out from the matlab path any routines
%   related to macyaeal or cielo. 
%
%   Usage:
%      usenamespace(package)

global ISSM_DIR

%First, add all packages in the path, so that when we erase them, rmpath does not error 
%out. 
addpath(genpath_ice([ISSM_DIR '/src/m/solutions/macayeal']));
addpath(genpath_ice([ISSM_DIR '/src/m/solutions/ice']));
addpath(genpath_ice([ISSM_DIR '/src/m/solutions/cielo']));

%binaries for running using cielo
addpath(genpath_ice([ISSM_DIR '/bin']));


%Now, erase according to package
if strcmpi(package,'macayeal'),
rmpath(genpath_ice([ISSM_DIR '/src/m/solutions/ice']));
rmpath(genpath_ice([ISSM_DIR '/src/m/solutions/cielo']));
rmpath(genpath_ice([ISSM_DIR '/bin']));
end

if strcmpi(package,'ice'),
rmpath(genpath_ice([ISSM_DIR '/src/m/solutions/macayeal']));
rmpath(genpath_ice([ISSM_DIR '/src/m/solutions/cielo']));
rmpath(genpath_ice([ISSM_DIR '/bin']));
end

if strcmpi(package,'cielo'),
rmpath(genpath_ice([ISSM_DIR '/src/m/solutions/macyeal']));
rmpath(genpath_ice([ISSM_DIR '/src/m/solutions/ice']));
end
