%
%  definition for the least_squares_term class.
%
%  [lst]=least_squares_term(varargin)
%
classdef least_squares_term
    properties
        descriptor='';
        scale_type='none';
        scale     = 1.;
        weight    = 1.;
    end
    
    methods
        function [lst]=least_squares_term(varargin)

            switch nargin

%  create a default object

                case 0

%  copy the object or create the object from the input

                otherwise
                    if  (nargin == 1) && isa(varargin{1},'least_squares_term')
                        lst=varargin{1};
                    else
                        lst.descriptor=varargin{1};

                        if (nargin >= 2)
                            lst.scale_type=varargin{2};
                            if (nargin >= 3)
                                lst.scale     =varargin{3};
                                if (nargin >= 4)
                                    lst.weight    =varargin{4};

                                    if (nargin > 4)
                                        warning('objective_function:extra_arg',...
                                            'Extra arguments for object of class ''%s''.',...
                                            class(lst));
                                    end
                                end
                            end
                        end
                    end
            end

        end
        function [desc]  =dresp_desc(lst)
            desc=cell(size(lst));
            for i=1:numel(lst)
                desc(i)=cellstr(lst(i).descriptor);
            end
        end
        function [stype ]=dresp_stype(lst)
            stype=cell(size(lst));
            for i=1:numel(lst)
                stype(i)=cellstr(lst(i).scale_type);
            end
        end
        function [scale] =dresp_scale(lst)
            scale=zeros(size(lst));
            for i=1:numel(lst)
                scale(i)=lst(i).scale;
            end
        end
        function [weight]=dresp_weight(lst)
            weight=zeros(size(lst));
            for i=1:numel(lst)
                weight(i)=lst(i).weight;
            end
        end
        function [lower] =dresp_lower(lst)
            lower=[];
        end
        function [upper] =dresp_upper(lst)
            upper=[];
        end
        function [target]=dresp_target(lst)
            target=[];
        end
    end
end
