/* This is third-party software that is distributed with Acro.
 * For licensing information concerning this file, see the Acro home page:
 * http://software.sandia.gov/Acro
 */

///////////////////////////////////////////////////////////////////
/*****************************************************************
Copyright: Artificial Life and Adaptive Robotics Laboratory - ALAR
School of ITEE, UNSW@ADFA, Australia, 2005
*******************************************************************/
///////////////////////////////////////////////////////////////////

//#include "stdafx.h"
#include "individual.h"
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

individual::individual()
{
	InumberofGenes=0;
	InumberofObjs=0;
	chromosome_len=0;
	DglobalFitness=0;
	rank=-1;
	setNULL();	
}

//DEL individual::individual(int n_Genes,int n_Objs)
//DEL {
//DEL 	InumberofGenes=n_Genes;
//DEL 	InumberofObjs=n_Objs;
//DEL 	setNULL();
//DEL }

individual::individual(int n_Genes,int n_Objs,int *GSize,double *Ub,double *Lb,double *real_params,int withbinary)
{
	DglobalFitness=0;
	rank=-1;
	Initialize(n_Genes,n_Objs,GSize,Ub,Lb,real_params,withbinary);
}
void individual::Initialize(int n_Genes,int n_Objs,int *GSize,double *Ub,double *Lb,double *real_params,int withbinary)
{
	InumberofGenes=n_Genes;
	InumberofObjs=n_Objs;
	setNULL();	
	
	Isize=new int[InumberofGenes];
	DfitnessC=new double[InumberofObjs];
	DfitnessN=new double[InumberofObjs];
	Dgenes=new double[InumberofGenes];
	Dlower=new double[InumberofGenes];
	Dupper=new double[InumberofGenes];

	InitializeI(GSize);
	InitializeUBounds(Ub);
	InitializeLBounds(Lb);
	InitializeD(real_params);
	if (withbinary)
	{
		Bgenes=new unsigned int[chromosome_len];
		InitializeB(real_params);
	}
}
//DEL void individual::Initialize_withoutBR(int n_Genes,int n_Objs,int *GSize,double *Ub,double *Lb,double *real_params)
//DEL {
//DEL 	InumberofGenes=n_Genes;
//DEL 	InumberofObjs=n_Objs;
//DEL 
//DEL 	InitializeI(GSize);
//DEL 	InitializeUBounds(Ub);
//DEL 	InitializeLBounds(Lb);
//DEL 	InitializeD(real_params);
//DEL 	//InitializeB(real_params);
//DEL }
individual::~individual()
{
	if (Dgenes) 
	{delete Dgenes; Dgenes=NULL;}
	if (Bgenes) 
	{delete Bgenes; Bgenes=NULL;}
	if (Isize) 
	{delete Isize;Isize=NULL;}
	if (Dupper) 
	{delete Dupper;Dupper=NULL;}
	if (Dlower) 
	{delete Dlower;Dlower=NULL;}
	if (DfitnessC) 
	{delete DfitnessC;DfitnessC=NULL;}
	if (DfitnessN) 
	{delete DfitnessN;	DfitnessN=NULL;}
	//setNULL();
}



 unsigned int* individual::value2string(double value, int gene_index, int &lsize)
 {

 	unsigned long d_value=0;
 	unsigned int s=0;
 	
	d_value=(unsigned long)((value-Dlower[gene_index])*(pow(2,Isize[gene_index])-1)/(Dupper[gene_index]-Dlower[gene_index]));
 	unsigned int* temp = d2b(d_value,s);  // -> return s value as well
	lsize=s;	
	return temp;
 }

unsigned long individual::b2d(unsigned int *digits,unsigned int lbits)
 {
 	unsigned long c=0;
 	for(unsigned int i=0;i<lbits;i++)
 	{
 		if (digits[i]==1)
 			c += (unsigned long)pow(2,lbits-1-i);
 	}
 	return c;
 }
 unsigned int* individual::d2b(unsigned long number, unsigned int &lbits)
 {
 	
 	int	remain = 0;
 	int	i,c = 0;
 	unsigned int binary[32];
 
 	while( number != 0 )
 	{
 		remain = number % 2;
 		number = number / 2;
 		if (remain==1)
 			binary[c] = 1;
 		else
 			binary[c]=0;
 		c++;
 	}
 	unsigned int *temp=new unsigned int[c];
 	for (i=0;i<c;i++)
 		temp[i]=binary[c-1-i];

	lbits=c;

	
 	return temp;
 }

 void individual::set_chromosome(unsigned int *ch)
 {
 	int i;
	for (i=0;i<chromosome_len;i++)
		 Bgenes[i]=ch[i];
	 // set Bgenes
	 for(i=0;i<InumberofGenes;i++)
	 
		 Dgenes[i]=decode_gene(i);
 }


void individual::InitializeB(double *values)
{
if (values)
{

	int i,j,k,gs=0,cp=0;
	for(i=0;i<chromosome_len;i++)
		Bgenes[i]=0;
	for(i=0;i<InumberofGenes;i++)
	{
			cp +=Isize[i];
			j=cp-1;
			unsigned int *st=value2string(values[i],i,gs);
			for (k=gs-1;k>=0;k--)
			{
				Bgenes[j]=st[k];
				j--;
			}
			if (st) {delete [] st; st=NULL;}
	}
}

}
void individual::InitializeD(double *values)
{
if (values)
{


	for(int i=0;i<InumberofGenes;i++)
	Dgenes[i]=values[i];	
}
}
void individual::InitializeI(int *sizelist)
{
if (sizelist)
{

	chromosome_len=0;
	for(int i=0;i<InumberofGenes;i++)
	{
	Isize[i]=sizelist[i];
	chromosome_len+=sizelist[i];
	}
}
}

void individual::InitializeUBounds(double * bounds)
{
if (bounds)
{

 for (int i=0;i<InumberofGenes;i++)
	Dupper[i]=bounds[i];

}
}
void individual::InitializeLBounds(double * bounds)
{
	if (bounds)
	{

	 for (int i=0;i<InumberofGenes;i++)
		Dlower[i]=bounds[i];
	}
}

void individual::print_fn(ofstream &f)
{
	int i;
	
//	for (i=0;i<InumberofGenes;i++)
//		f << setiosflags(ios::fixed|ios::showpoint) << setprecision(12) << Dgenes[i] << "  ";
//	f << "  ";
	for (i=0;i<InumberofObjs;i++)
		f << setiosflags(ios::fixed|ios::showpoint) << setprecision(6) << DfitnessC[i] << "\t";
//	for (i=0;i<InumberofObjs;i++)
//		f << setiosflags(ios::fixed|ios::showpoint) << setprecision(6) << DfitnessN[i] << "\t";
	f << endl;
}
void individual::print_x(ofstream &f)
{
	int i;
	for (i=0;i<InumberofGenes;i++)
		f << setiosflags(ios::fixed|ios::showpoint) << setprecision(6) << Dgenes[i] << " \t";
	f << endl;
}

void individual::print(ofstream &f)
{
	int i;
	for (i=0;i<InumberofGenes;i++)
		f << setiosflags(ios::fixed|ios::showpoint) << setprecision(6) << Dgenes[i] << " \t";
	print_fn(f);
}

double individual::decode_gene(int index)
{

 	double c=0.0;
 	int i;
	int cp=Isize[index];
 	unsigned int *temp = new unsigned int[cp];
 	//copy
	int ci=0;
    for (i=0;i<=index-1;i++)
	{
		ci+=Isize[i];
	}
 	for(i=ci;i<ci+cp;i++)
 		temp[i-ci]=Bgenes[i];

 	c=b2d(temp,cp);
    
	if (temp) {delete [] temp;temp=NULL;}

 return (Dlower[index]+c*(Dupper[index]-Dlower[index])/(pow(2,cp)-1));

}
void individual::set_DfitnessN(double *values)
{
if (values)
{
 for (int i=0;i<InumberofObjs;i++)
	DfitnessN[i]=values[i];
}
}
void individual::set_DfitnessC(double *values)
{
if (values)
{

 for (int i=0;i<InumberofObjs;i++)
	DfitnessC[i]=values[i];
}
}

void individual::setNULL()
{
	
	Dgenes =NULL;
	Bgenes=NULL;
	Isize=NULL;
	Dupper=NULL;
	Dlower=NULL;
	DfitnessC=NULL;
	DfitnessN=NULL;
	
	

}

 individual &individual::operator=(const individual &id)
  {
   InumberofGenes=id.InumberofGenes;
   InumberofObjs=id.InumberofObjs;
   //chromosome_len=id.chromosome_len;
   DglobalFitness=id.DglobalFitness;
   rank=id.rank; 

	if (!Isize) Isize=new int[InumberofGenes];
	if (!DfitnessC) DfitnessC=new double[InumberofObjs];
	if (!DfitnessN) DfitnessN=new double[InumberofObjs];
	if (!Dgenes) Dgenes=new double[InumberofGenes];
	if (!Dlower) Dlower=new double[InumberofGenes];
	if (!Dupper) Dupper=new double[InumberofGenes];


   	InitializeI(id.Isize);
   	InitializeUBounds(id.Dupper);
   	InitializeLBounds(id.Dlower);
   	InitializeD(id.Dgenes);

   	if (id.Bgenes) 
	{
		if (!Bgenes) Bgenes=new unsigned int[chromosome_len];
		InitializeB(id.Dgenes);
	}
   	
	set_DfitnessC(id.DfitnessC);
   	set_DfitnessN(id.DfitnessN);

   	return *this;
   }
