/* This is third-party software that is distributed with Acro.
 * For licensing information concerning this file, see the Acro home page:
 * http://software.sandia.gov/Acro
 */

///////////////////////////////////////////////////////////////////
/*****************************************************************
Name: Hussein A. Abbass,
Artificial Life and Adaptive Robotics Laboratory - ALAR
School of ITEE, UNSW@ADFA, Australia
*******************************************************************/
///////////////////////////////////////////////////////////////////
#ifndef _RANDOM_H
#define _RANDOM_H

#include <stdlib.h>
#include <math.h>

class Random {
public:
	Random();
	double nextDouble();
	double nextGaussian();
	double nextGaussian(double,double);
	void   setSeed(int);
	void   setSeed(long);
private:
        long  idum;   // this is the seed
        long    IA;
        long    IM;
        double  AM;
        long    IQ;
        long    IR;
        long    NTAB;
        double  NDIV;
        double  EPS;
        double  RNMX;
        long iy;
        long *iv;
};

#endif
