function B=GetB_prog(triaelem,xyz_list,gauss_coord)
%GETB_PROG - compute Bprime matrix for a prognostic 
%
%   Compute B  matrix. B=[B1 B2 B3 ] where Bi is of size numgrids*NDOF
%   For grid i, Bi can be expressed in the basic coordinate system by:
%   Bi_basic=[h]
%            [h]
%   where h is the interpolation function for grid i.
%
%   Usage:
%      B=GetB_prog(triaelem,xyz_list,gauss_coord)
%
%   See also GETBPRIME_PROG, CREATEKMATRIX

num_grids=3;

%Get l1l2l3 in basic coordinate system: 
l1l2l3=GetNodalFunctions(triaelem,gauss_coord);

B=zeros(2,num_grids);
for i=1:num_grids,
	B(1,i)=l1l2l3(i);
	B(2,i)=l1l2l3(i);
end
