/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2001, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:	 NonDIntegration
//- Description: Implementation code for NonDIntegration class
//- Owner:       Mike Eldred
//- Revised by:  
//- Version:

#include "data_types.h"
#include "system_defs.h"
#include "NonDIntegration.H"
#include "DakotaModel.H"
#include "DakotaResponse.H"
#include "ProblemDescDB.H"

static const char rcsId[]="@(#) $Id: NonDIntegration.C,v 1.57 2004/06/21 19:57:32 mseldre Exp $";


namespace Dakota {

/** This constructor is called for a standard letter-envelope iterator
    instantiation.  In this case, set_db_list_nodes has been called
    and probDescDB can be queried for settings from the method
    specification.  It is not currently used, as there are not yet
    separate nond_quadrature/nond_sparse_grid method specifications. */
NonDIntegration::NonDIntegration(Model& model): NonD(model),
  numIntegrations(0)
{ initialize_random_variables(); }


/** This alternate constructor is used for on-the-fly generation and
    evaluation of numerical integration points. */
NonDIntegration::NonDIntegration(NoDBBaseConstructor, Model& model): 
  NonD(NoDBBaseConstructor(), model), numIntegrations(0)
{
  // The passed model (stored in iteratedModel) is G(u): it is recast to
  // standard space and does not include a DataFit recursion.

  // initialize_random_variables(data) is called externally and passed
  // x-space data from the external source.
}


NonDIntegration::~NonDIntegration()
{ }


void NonDIntegration::quantify_uncertainty()
{
  numIntegrations++;

  // check any updates from sampling_reset()
  check_input();

  // generate integration points
  get_parameter_sets(iteratedModel);

  // convenience function from Analyzer for evaluating parameter sets.  Data
  // flags are set to be compatible with DataFitSurrModel::build_global().
  evaluate_parameter_sets(iteratedModel, true, false);

  // Needed for general use outside of NonDPolynomialChaos
  //evaluate_integrals();
}

} // namespace Dakota
