#!/bin/bash
#This bash script install everything that needs to be set up in ice (compilation, startup, SuiteSparse)
#Make sure that CONFIG is the right OS system
#config_linux32.mk for a 32 bits linux OS, 
#config_linux64.mk for a 64 bits linux OS,
#config_mac.mk for Mac OS X

CONFIG="config_linux64.mk"

#go to root
cd $ISSM_DIR
HERE=`pwd`;

#check that ISSM_DIR is correctly set up
if [ $HERE != $ISSM_DIR ]; then

	cd ..

	#.bashrc or .cshrc not correctly configured, display error message
	echo "
	******************************* .bashrc or .cshrc not correctly configured *******************************

	In order for ISSM to work correctly, you should add the following lines in your shell
	environment script (.bashrc or .cshrc). 
	
	#ISSM 
	export ISSM_DIR=` pwd `
	source $ISSM_DIR/etc/environment.sh
	
	**********************************************************************************************************
	"
else
	#Ok, compile ISSM

	#Configure mex file
	cd etc
	ln -s $CONFIG  config.mk
	cd ..

	#Compile libraries
	cd packages
#		cd 	dakota  
#		sh install.sh
#		cd ..
#		cd 	doxygen  
#		sh install.sh
#		cd ..
#		cd 	gdal  
#		sh install.sh
#		cd ..
#		cd 	m2html 
#		sh install.sh
#		cd ..
		cd 	metis  
		sh install.sh
		cd ..
#		cd 	mpich2 
#		sh install.sh
#		cd ..
#		cd 	mtoc  
#		sh install.sh
#		cd ..
#		cd 	petsc  
#		sh install.sh
#		cd ..
#		cd 	qhull  
#		sh install.sh
#		cd ..
#		cd 	slepc  
#		sh install.sh
#		cd ..
		cd 	suitesparse 
		sh install.sh
		cd ..
		cd 	triangle
		sh install.sh
		cd ..
	cd ..

	#Compile ISSM
	make -f MakefileIce
fi
