function elemmatrix = elemmatrix(varargin)
%ELEMMATRIX - constructor for elemmatrix object
%
%   Usage:
%      elemmatrix = elemmatrix(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	elemmatrix.nrows=NaN;
	elemmatrix.row_indices=NaN;
	elemmatrix.terms=NaN;
	
	elemmatrix=class(elemmatrix,'elemmatrix');
case 1
	%If single argument we have a copy constructor. 
	argument = varargin{1};
	if isa(argument,'elemmatrix'),
		elemmatrix=argument;
	else 
		if isnumeric(varargin{1}),
			numdof=argument;
			elemmatrix.nrows=numdof;
			elemmatrix.row_indices=zeros(numdof,1);
			elemmatrix.terms=zeros(numdof,numdof);

			elemmatrix=class(elemmatrix,'elemmatrix');
		elseif isstruct(argument),
			elemmatrix=class(argument,'elemmatrix');
		else
			error('elemmmatrix constructor error message: invalid input argument');
		end
	end
otherwise
	error('elemmatrix constructor error message: 0 of 1 argument only in input.');
end
