/*  _________________________________________________________________________
 *
 *  Coliny: A Library of COLIN optimizers
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top Coliny directory.
 *  _________________________________________________________________________
 */

/**
 * \file EApoint.h
 *
 * Defines the coliny::EApoint class.
 */

#ifndef coliny_EApoint_h
#define coliny_EApoint_h

#include <acro_config.h>
#include <utilib/PackObject.h>
#include <coliny/DomainInfoBase.h>

namespace coliny {

using utilib::PackBuffer;
using utilib::UnPackBuffer;

///
template <class DomainT, class InfoT=DomainInfoBase>
class EApoint : public utilib::PackObject
{
public:

  ///
  EApoint() {}

  ///
  EApoint(const EApoint<DomainT,InfoT>& pt)
		{*this = pt;}

  ///
  virtual ~EApoint() {}

  ///
  virtual EApoint<DomainT,InfoT>& operator=(const EApoint<DomainT,InfoT>& pt)
		{
		point = pt.point;
		return *this;
		}

  ///
  virtual bool operator==(const EApoint<DomainT,InfoT>& pt) const
		{return (point == pt.point);}

  ///
  virtual void copy(const EApoint<DomainT,InfoT>& pt)
		{
		point << pt.point;
		info.copy(pt.info);
		}

  ///
  virtual void write_point(std::ostream& os) const
		{os << point;}

  ///
  virtual void ls_info(std::ostream&) const {}
 
  ///
  virtual void write(std::ostream& os) const
		{os << point << info;}

  ///
  virtual void read(std::istream& is)
		{is >> point >> info;}

  ///
  virtual void write(PackBuffer& pack) const
		{pack << point << info;}

  ///
  virtual void read(UnPackBuffer& unpack)
		{unpack >> point >> info;}

  ///
  DomainT point;

  ///
  InfoT info;

};

} // namespace coliny

#endif
