function plot_transient_movie(md,options_structure,width,i);
%PLOT_TRANSIENT_MOVIE - plot a transient result as a movie
%   Usage:
%      plot_transient_movie(md,options_structure,width,i);
%
%   See also: PLOTMODEL

	%plot mesh boundaries
	subplot(width,width,i); 

	%first load x,y, etc ... to speed up plot
	x=md.x;
	x2d=md.x2d;
	y=md.y;
	y2d=md.y2d;
	z=md.z;
	z2d=md.z2d;
	elements2d=md.elements2d;
	elements=md.elements;
	elements_type2d=md.elements_type2d;

	%units
	if ~isnan(options_structure.unitmultiplier),
		md.x=md.x*options_structure.unitmultiplier;
		md.y=md.y*options_structure.unitmultiplier;
		md.z=md.z*options_structure.unitmultiplier;
	end

	%edgecolor?
	if ~isnan(options_structure.edgecolor),
		edgecolor=options_structure.edgecolor;
	else
		edgecolor='none';
	end

	if strcmpi(md.type,'2d') 
		choice=input('Which field do you want to plot? (vel/vx/vy/thickness/surface/bed)','s');

		if ~strcmp(choice,'vel') & ~strcmp(choice,'vx') & ~strcmp(choice,'vy') & ~strcmp(choice,'thickness') & ~strcmp(choice,'bed') & ~strcmp(choice,'surface')
			disp('plot_transient_movie error message: input not supported yet, exiting...')
			return
		end
		if ~isnan(options_structure.noiceshelf) & options_structure.noiceshelf,
			pos=find(md.gridoniceshelf);
			data(pos)=NaN;
		end
		if ~isnan(options_structure.noiceshelf) & options_structure.noicesheet,
			pos=find(md.gridonicesheet);
			data(pos)=NaN;
		end
		for i=1:length(md.transient_results)
			eval(['data=md.transient_results(' num2str(i) ').' num2str(choice) ';']);
			titlestring=[choice ' at time ' num2str(md.transient_results(i).time) ' year'];
			A=elements(:,1); B=elements(:,2); C=elements(:,3); 
			patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', data,'FaceColor','interp','EdgeColor',edgecolor);
			apply_options_movie(options_structure,titlestring);
			pause(0.5)
		end

	else
		choice=input('Which field do you want to plot? (vel/vx/vy/vz/thickness/surface/bed/temperature)','s');

		if ~strcmp(choice,'vel') & ~strcmp(choice,'vx') & ~strcmp(choice,'vy') & ~strcmp(choice,'vz') & ~strcmp(choice,'temperature') & ~strcmp(choice,'thickness') & ~strcmp(choice,'bed') & ~strcmp(choice,'surface')
			disp('plot_transient_movie error message: input not supported yet, exiting...')
			return
		end
		if ~isnan(options_structure.noiceshelf) & options_structure.noiceshelf,
			pos=find(md.gridoniceshelf);
			data(pos)=NaN;
		end
		if ~isnan(options_structure.noiceshelf) & options_structure.noicesheet,
			pos=find(md.gridonicesheet);
			data(pos)=NaN;
		end
		for i=1:length(md.transient_results)
			eval(['data=md.transient_results(' num2str(i) ').' num2str(choice) ';']);
			titlestring=[choice 'at time ' num2str(md.transient_results(i).time) ' a'];
			A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
			patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', data,'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', data,'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', data,'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', data,'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', data,'FaceColor','interp','EdgeColor',edgecolor);
			apply_options_movie(options_structure,titlestring);
			pause(0.5)
		end
	end

end %function

function apply_options_movie(options_structure,titlestring)
	%apply options
	if isnan(options_structure.title)
		options_structure.title=titlestring;
	end 
	if isnan(options_structure.colorbar)
		options_structure.colorbar=1;
	end
	applyoptions(md,[],options_structure);
end
