function plot_tensor_principalaxis(md,options_structure,width,i,tensor,type,plot_options);
%PLOT_TENSOR_PRINCIPALAXIS - plot ytensor principal axis
%
%   Usage:
%      plot_tensor_principalaxis(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%plot mesh boundaries
subplot(width,width,i); 


if (strcmpi(md.type,'2d')),
	eval(['Vx=tensor.principalaxis' type(end) '(:,1); Vy=tensor.principalaxis' type(end) '(:,2);'])
else
	eval(['Vx=tensor.principalaxis' type(end) '(:,1); Vy=tensor.principalaxis' type(end) '(:,2); Vz=tensor.principalaxis' type(end) '(:,3);'])
end

%smoothing?
if strcmpi(options_structure.smooth,'yes') & length(Vx)==md.numberofelements
	Vx=elementstogrids(md,Vx);
	Vy=elementstogrids(md,Vy);
	if (strcmpi(md.type,'3d')),
		Vz=elementstogrids(md,Vz);
	end
end
		
%layer projection? 
if ~isnan(options_structure.layer) & options_structure.layer>=1,
	Vx=project2d(md,Vx,options_structure.layer); %project onto 2d mesh
	Vy=project2d(md,Vy,options_structure.layer); %project onto 2d mesh
	if (strcmpi(md.type,'3d')),
		Vz=project2d(md,Vz,options_structure.layer); %project onto 2d mesh
	end
	%we modify the mesh temporarily to a 2d mesh from which the 3d mesh was extruded. 
	md.x=md.x2d;
	md.y=md.y2d;
	md.z=md.z2d;
	md.elements=md.elements2d;
	md.elements_type=md.elements_type2d;
	md.type='2d';
end

%units
if ~isnan(options_structure.unitmultiplier),
	md.x=md.x*options_structure.unitmultiplier;
	md.y=md.y*options_structure.unitmultiplier;
	md.z=md.z*options_structure.unitmultiplier;
end
if length(Vx)==length(md.elements),
	
	if ~isnan(options_structure.noiceshelf) & options_structure.noiceshelf,
		Vx(find(md.elementoniceshelf))=NaN;
		Vy(find(md.elementoniceshelf))=NaN;
		Vz(find(md.elementoniceshelf))=NaN;
	end
	if ~isnan(options_structure.noicesheet) & options_structure.noicesheet,
		Vx(find(~md.elementoniceshelf))=NaN;
		Vy(find(~md.elementoniceshelf))=NaN;
		Vz(find(~md.elementoniceshelf))=NaN;
	end

	if (strcmpi(md.type,'2d')),
		x=mean(md.x(md.elements'))'; y=mean(md.y(md.elements'))';
		A=md.elements(:,1); B=md.elements(:,2); C=md.elements(:,3);
		quiver(x,y,Vx,Vy)

	else
		x=mean(md.x(md.elements'))'; y=mean(md.y(md.elements'))'; z=mean(md.z(md.elements'))';
		A=md.elements(:,1); B=md.elements(:,2); C=md.elements(:,3); D=md.elements(:,4); E=md.elements(:,5); F=md.elements(:,6);
		quiver3(x,y,z,Vx,Vy,Vz)
	end
elseif length(Vx)==md.numberofgrids |  length(Vx)==md.numberofgrids2d,
	if ~isnan(options_structure.noiceshelf) & options_structure.noiceshelf,
		pos=find(md.gridoniceshelf);
		Vx(pos)=NaN;
		Vy(pos)=NaN;
		Vz(pos)=NaN;
	end
	if ~isnan(options_structure.noiceshelf) & options_structure.noicesheet,
		pos=find(md.gridonicesheet);
		Vx(pos)=NaN;
		Vy(pos)=NaN;
		Vz(pos)=NaN;
	end

	if strcmpi(md.type,'2d'),
                quiver(md.x,md.y,Vx,Vy)
	else
		quiver3(md.x,md.y,md.z,Vx,Vy,Vz)
	end
end

%apply options
if isnan(options_structure.title)
	strings=strsplit(type,'_');
	string=strings{1};
	options_structure.title=[upper(string(1)) string(2:end) ' principal axis ' type(end)];
end 
if isnan(options_structure.colorbar)
	options_structure.colorbar=0;
end
applyoptions(md,[],options_structure);
