function spc = spc(varargin)
%SPC - constructor for spc object
%
%   Usage:
%      spc = spc(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	spc.type='spc';
	spc.grid=NaN; %grid number for this constraint
	spc.dof=NaN; %c is the dof for the corresponding constraint ( 1<=c<=6, for all (x,y,z) deformations + (x,y,z) rotations)
	spc.value=NaN; %d is the value of the constraint.
	spc=class(spc,'spc');
				
case 1
	%If single argument of class spc, we have a copy constructor. 
	if (isa(varargin{1},'spc'))
		spc = varargin{1};
	else
		error('spc constructor error message: copy constructor called on a non ''spc'' class object');
	end 
otherwise
	error('spc constructor error message: 0 of 1 argument only in input.');
end
