function [n1,n2]=GetNumberOfActiveElements(elements)
%GETNUMBEROFACTIVEELEMENTS - get the number of active elements
%
%   Go through all elements, and if we find one with special characteristics, 
%   like the MacAyeal's accelerated element, then we need to updat nel. 
%
%   Usage:
%      [n1,n2]=GetNumberOfActiveElements(elements)

for n=length(elements):-1:1, %start from the end, where we usually put the special elements.

	if strcmp(elements(n).element.type,'acceleratedtriaelem'),
		%we have an accelerated triaelem, stop the loop, and return  n1 n2
		n1=n; 
		n2=n;
		return;
	end
end

%If we are here, no special elements, return n1=1, n2=length(elements)
n1=1;
n2=length(elements);
