/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

//
// OptProblem Evaluation test
//

#include <acro_config.h>
#include <utilib/std_headers.h>
#include <utilib/stl_auxillary.h>
#include <colin/colin.h>

using namespace std;
using namespace colin;

class A {
public:
  vector<double> vec;
};

ostream& operator<<(ostream& os, const A& a)
{ os << a.vec; return os; }

istream& operator>>(istream& is, A& a)
{ is >> a.vec; return is; }

namespace colin {

template<>
void map_domain(A& a, const A& b)
{ a.vec &= b.vec; }

}

int ctr=0;
double func5(const double*, int n)
{
ctr++;
return -99.0-ctr;
}

void fooVec()
{
OptProblem<utilib::pvector<double> > opt;
OptSetup(opt,&func5);

utilib::pvector<double> a;
real value;
opt.EvalF(a,value);
cout << "Sync Value: " << value << endl;
opt.AsyncEvalF(a,&value);
opt.synchronize();
cout << "AsyncSync Value: " << value << endl;
}


void fooVec2()
{
OptProblem<utilib::pvector<double> > opt;
OptSetup(opt,&func5);

utilib::pvector<double> a;
utilib::pvector<real > value(10);

for (int i=0; i<10; i++)
  opt.EvalF(a,value[i]);
cout << "Sync Value: " << value << endl;

for (int i=0; i<10; i++)
  opt.AsyncEvalF(a,&(value[i]));
opt.synchronize();
cout << "AsyncSync Value: " << value << endl;
}


int main()
{
for (int i=0; i<20; i++) {
  fooVec();
  }
fooVec2();
return 0;
}

