*   _______________________________________________________________________
*
*   DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
*   Copyright (c) 2006, Sandia National Laboratories.
*   This software is distributed under the GNU General Public License.
*   For more information, see the README file in the top Dakota directory.
*   _______________________________________________________________________
*
      character*72 line
      integer i, point
      real time, temp, g_temp, tmpbar
c
      open(unit=11,file='coyote_opt.dat')
c     
c - read header line     
c
      read(11,100)line
c     
c - Initialize data (temp_bar in degrees Celcius)
c
      tmpbar = 232.
      
      do 20 i = 1,8
         read(11,*) point, time, temp
c         tmax = max(temp,tmax)
 20   continue
c
c - Capture temp at o-ring (point 8) for evaluation of constraint
c - g_temp = (temp_pt8 - temp_bar)/temp_bar <= 0.
c
      g_temp = (temp - tmpbar)/tmpbar
      write(*,120) g_temp
 100  format(a72)
 120  format(f13.10)
      stop 
      end
