/* This is third-party software that is distributed with Acro.
 * For licensing information concerning this file, see the Acro home page:
 * http://software.sandia.gov/Acro
 */

///////////////////////////////////////////////////////////////////
/*****************************************************************
Copyright: Artificial Life and Adaptive Robotics Laboratory - ALAR
School of ITEE, UNSW@ADFA, Australia, 2005
*******************************************************************/
///////////////////////////////////////////////////////////////////

#include "operators_NSGA2.h"
#include <assert.h>

operators_NSGA2::~operators_NSGA2() {
	if (max_values) {delete [] max_values; max_values=NULL;}
	if (min_values) {delete [] min_values; min_values=NULL;}
	if (obj) delete obj;
}

// create population q from population p by crowded tournament selection
void operators_NSGA2::selection(population &q,population &p)   // same size
{

	int size=p.pop_size;  // population size , the same for both a and p
	
	
	individual mate1,mate2;
	
	int index1,index2,rank1,rank2;
	int c=0;
	
	
	crowding_sort(p, FALSE);

	while(c<size)
	{

		index1=(int)(rnd.nextDouble()*(size)); 
		if (index1>=size) index1=size-1;
		
		index2=(int)(rnd.nextDouble()*(size));
		if (index2>=size) index2=size-1;
		
		mate1=p.individuals[index1];
		mate2=p.individuals[index2];
		
		rank1=mate1.rank;// p.rank[index1];
		rank2=mate2.rank;// p.rank[index2];
		
		//crowded tournament selection
		if (rank1<rank2) 
			q.individuals[c]=mate1; 
		if (rank1>rank2)
			q.individuals[c]=mate2;
		if (rank1==rank2)
		{
			if (mate1.DglobalFitness>mate2.DglobalFitness)
				q.individuals[c]=mate1;
			else
				q.individuals[c]=mate2;
		}
		c += 1;
	}

}

void operators_NSGA2::crossover(population &pop)
{
 	individual mate1,mate2;
 	int size=pop.pop_size;
 	int CH_LEN=pop.individuals[0].chromosome_len;
 	
 
  	int csite=0,i,index, counter=0;
  	
  	int nc=0;	
  	

  	
 	unsigned int *cc1=new unsigned int[CH_LEN]; 
 	unsigned int *cc2=new unsigned int[CH_LEN];
 	unsigned int *cm1=new unsigned int[CH_LEN];
 	unsigned int *cm2=new unsigned int[CH_LEN];
  	individual temp;//=NULL;
	index=0;
	temp=pop.individuals[0];
 	while (counter<size)
 	{
  		// selcect parents
  		
 		mate1=pop.individuals[index] ;
		index++;
 		
  		mate2=pop.individuals[index];
  		index++;
 		copyarray(cm1,mate1.Bgenes,CH_LEN);
 		copyarray(cm2,mate2.Bgenes,CH_LEN);
 
 
  		//crossover
  		double r=rnd.nextDouble();
  		if (r<=pc) // do crossover
  		{
  			nc++;
  			csite=(int)(rnd.nextDouble()*(CH_LEN));
			if (csite>=CH_LEN) csite=CH_LEN-1;
  			for (i=0;i<csite;i++)
  			{
  				cc1[i]=cm1[i];cc2[i]=cm2[i];
  			}
  			for (i=csite;i<CH_LEN;i++)
  			{
  				cc1[i]=cm2[i];cc2[i]=cm1[i];
  			}
  		}
  		else  //  copying
  		{
  			for (i=0;i<CH_LEN;i++)
  			{
  				cc1[i]=cm1[i];
  				cc2[i]=cm2[i];
  			}
  		}

 		
		temp.set_chromosome(cc1);
 		set_objectivevalue(temp,temp.Dgenes); 
 		pop.individuals[counter]=temp; 
 		

  		temp.set_chromosome(cc2); 
 		set_objectivevalue(temp,temp.Dgenes);
 		pop.individuals[counter+1]=temp;
 		counter += 2;
    }

	if (cc1) {delete [] cc1;cc1=NULL;}
	if (cc2) {delete [] cc2;cc2=NULL;}
	if (cm1) {delete [] cm1;cm1=NULL;}
	if (cm2) {delete [] cm2;cm2=NULL;}
}

void operators_NSGA2::mutation(population &pop)
{
  	if ((pm<=0)||(pm>1)) return;
 
 	int size=pop.pop_size;
 	int CH_LEN=pop.individuals[0].chromosome_len;
 
  	int i,counter=0;
  	double r;
  	int nc=0;	
  	unsigned int *cm1=new unsigned int[CH_LEN];
 	
 
 	individual mate1;
 	individual temp;//=NULL;
	temp=pop.individuals[0];
  	while (counter<size)
  	{
  		mate1=pop.individuals[counter];
  		copyarray(cm1,mate1.Bgenes,CH_LEN);
  		
  		for (i=0;i<CH_LEN;i++)
  		{
  			r=rnd.nextDouble();
  			if (r<=pm)
  			{
  				cm1[i]=(cm1[i]==0)?1:0;
  			}
  		}
  		
 		
		temp.set_chromosome(cm1);
 		set_objectivevalue(temp,temp.Dgenes); 
 		
 		pop.individuals[counter]=temp; 
  		
 		counter += 1;
  	}
  

	if (cm1) {delete [] cm1;cm1=NULL;}
}

void operators_NSGA2::crowding_sort(population &F, int sort)
{
	
	int i,j,k,size = F.pop_size;
	//int m;
	


	double t1,t2;
	individual Itemp;
	for (i=0;i<size;i++)    // to store array index
	{

		F.individuals[i].DglobalFitness=0;
	}
	
	int NObjs=F.individuals[0].InumberofObjs;
	
	if (size<=2) return;   // 2 individuals: select which one?
	
	for (k=0;k<NObjs;k++)   // sort the set in the order of ith objective
	{

		for(i=0;i<size-1;i++)
		for (j=i+1;j<size;j++)	
		{

				t1=F.individuals[i].DfitnessN[k];
				t2=F.individuals[j].DfitnessN[k];

			if (t1>t2)
			{
				Itemp=F.individuals[i];
				F.individuals[i]=F.individuals[j];
				F.individuals[j]=Itemp; 
			}
		}
		
		F.individuals[0].DglobalFitness=D_MAX;
		F.individuals[size-1].DglobalFitness=D_MAX;
		
		for(i=1;i<size-1;i++)
		{
			double temp=F.individuals[i].DglobalFitness;
			if (temp<D_MAX)
			{
				temp+=std::fabs(F.individuals[i+1].DfitnessN[k]-F.individuals[i-1].DfitnessN[k])/(max_values[k]-min_values[k]);	
				F.individuals[i].DglobalFitness=temp; 
			}
		}
	}
////////sorting crowding values: descending order ///////////////////////////////////
	if (sort){		
		for(i=0;i<size-1;i++)
		for (j=i+1;j<size;j++)	
		{
			t1=F.individuals[i].DglobalFitness;
			t2=F.individuals[j].DglobalFitness;
			if (t1<t2)
			{
				Itemp=F.individuals[i];
				F.individuals[i]=F.individuals[j];
				F.individuals[j]=Itemp; 
			}
		}
	}
}

void operators_NSGA2::set_objectivevalue_maxmin(population &p, int size)
{
	int i,j;
	int p_size=p.pop_size; 
	min_values= new double[size];
	max_values= new double[size];
	for (i=0;i<size;i++)
	{


		min_values[i]=p.individuals[0].DfitnessN[i];
		max_values[i]=p.individuals[0].DfitnessN[i];
		for (j=1;j<p_size;j++)
		{	

			if (p.individuals[j].DfitnessN[i]<min_values[i])
				min_values[i]=p.individuals[j].DfitnessN[i];
			
			if (p.individuals[j].DfitnessN[i]>max_values[i])
				max_values[i]=p.individuals[j].DfitnessN[i];
		}	
	}
	
}

void operators_NSGA2::copyarray(unsigned int *&d, unsigned int *s,int size)
{
 for (int i=0;i<size;i++)
	d[i]=s[i];
}

void operators_NSGA2::initialize_population(const int n_Genes,int n_Objs,int *GSize,double *Ub,double *Lb,population &pop)
{
	int i,j;
	double *real_params;

	real_params=new double[n_Genes];



	individual *id_temp=NULL;


 	for(i=0;i<pop.pop_size;i++)
 	{
		
		for(j=0;j<n_Genes;j++)     // initialize real values for x1,x2,..xn
			real_params[j]=rnd.nextDouble()*(Ub[j]-Lb[j]);

		if (id_temp) {delete id_temp;id_temp=NULL;}
		id_temp=new individual(n_Genes,n_Objs,GSize,Ub,Lb,real_params,TRUE); 
 		

		
		set_objectivevalue(*id_temp,real_params);
  
		
		pop.individuals[i]=*id_temp; 
 	}
	
	if (real_params) {delete [] real_params; real_params=NULL;}
	if (id_temp) {delete id_temp;id_temp=NULL;}

}

void operators_NSGA2::set_objectivevalue(individual &id, double *real_params) {

    int j,n_Objs=id.InumberofObjs;
    int n_Genes=id.InumberofGenes; 
    
    double *fitness=new double[n_Objs];

    if (dev <= 0.0) {
	obj->evaluate( real_params, n_Genes, fitness, n_Objs);
	id.set_DfitnessC(fitness);
	id.set_DfitnessN(fitness);
    } else {
	obj->evaluate( real_params, n_Genes, fitness, n_Objs);
	id.set_DfitnessC(fitness);
    
// injects noise ... or something
//	    for(j=0;j<n_Objs;j++)   // calculate fitness value without noise
//	    {
//		if (objID==5)
//		fitness[j]=rnd.nextGaussian(0.0,dev*25)+ problem5(id.Bgenes,id.chromosome_len,j);
//		else
//		fitness[j]=(rnd.nextGaussian(0.0,dev)+((*obj.objective_func)(real_params,n_Genes,j)));
//	    }
	id.set_DfitnessN(fitness);  
    }

    if (fitness) {
	delete [] fitness;
	fitness=NULL;
    }
}

void operators_NSGA2::combination(population &R, population &Q, population &P)
{
	int size=P.pop_size;
	int i;
	for (i=0;i<2*size;i++)
	{
		if (i<size)
			R.individuals[i]=P.individuals[i];
		else
			R.individuals[i]=Q.individuals[i-size];
	}
}

void operators_NSGA2::Evolve(int population_size, int N_generation, int SEED, int n_Genes,int n_Objs,int *GSize,double *Ub,double *Lb)
{
	P.set_pop_size(population_size);     // parrent population: size N
	Q.set_pop_size(population_size);     // offspring population: size N
	R.set_pop_size(2*population_size);    // size 2*N
	
	
	int rk;    // to store rank maximum
	int *nrank=NULL;   // to store the total individuals belong to each rank
	int i,j,genNo=0;
	
	n_SEED=SEED;
	n_GEN=N_generation;
	rnd.setSeed(n_SEED);
	
	// intialize the population P
	initialize_population(n_Genes,n_Objs,GSize,Ub,Lb,P); 


	// print to file
	
	char *filename=new char[40];
	//char *st=new char[3];
	
	char *st_dev=new char[5];
	sprintf(st_dev,"%0.2f_",dev);
	

	char *st_prob=new char[2];
	sprintf(st_prob,"%d_",objID);
	
	char *st_seed=new char[5];
	sprintf(st_seed,"%d_",n_SEED);
	
	// Main NSGA2 loop	
	while (genNo<=n_GEN)
	{
		
		cout << genNo<< endl;


		strcpy(filename,".//data//");
		strcat(filename,st_dev);
		strcat(filename,st_prob);
		strcat(filename,st_seed);
		strcat(filename,"Pareto_NSGA2");
		//strcat(filename,st);
		
		strcat(filename,".txt");
		ofstream f1(filename,ios::app);
		
		strcpy(filename,"");
		
		strcpy(filename,st_dev);
		strcat(filename,st_prob);
		strcat(filename,st_seed);

		strcat(filename,"Pareto_noise_NSGA2");
		//strcat(filename,st);
		strcat(filename,".txt");
		
		ofstream f2(filename,ios::app);

		
		
	///////	// CREATE offspring Q from P /////////////////////////////////////////////

	    // find max min between objective values /////////////////
		set_objectivevalue_maxmin(P,n_Objs); 

		P.rankingC(); 
		f2 << "1000000" << endl;
//		P.print_ParetoOptimal_fn(genNo,f1); 
		P.print_ParetoOptimal(genNo,f1); 


		P.rankingN(); 
		f1 << "1000000" << endl;
		P.print_ParetoOptimal(genNo,f2); 
		
		

		// variation
		selection(Q,P);  // create mating pool Q
		crossover(Q);   
		mutation(Q);
		
		
		// combine P and Q -> R
		combination(R,Q,P); 	

	//////////// BUILD P(t+1) from different fronts, and assign to P for next generation
		
		set_objectivevalue_maxmin(R,n_Objs);    // minmax values need to be recalculated after each generation
		R.rankingN();
		
		rk=R.rank_level;      // get max rank
		
		if (nrank) {delete [] nrank; nrank=NULL;}
		nrank = new int[rk];        
		
		for (i=0;i<rk;i++)       // initialize ranking array
			nrank[i]=0;

		for (i=0;i<2*population_size;i++)      // calaculate total individuals belong to each rank
			nrank[R.individuals[i].rank]+=1; 
		
		int counter=0; // to track the index in F
		int current_count=0;    // to store the current size of P(t+1)
		for (i=0;i<rk;i++)
		{
			if (current_count>=population_size) break;
			
			counter=0;
						
			F.set_pop_size(nrank[i]);     // get each front into F

			for (j=0;j<2*population_size;j++)           
				if (R.individuals[j].rank==i)
				{
					F.individuals[counter]=R.individuals[j];
					counter++;
				}
			//..process F..................
			
			if (current_count+nrank[i]<=population_size)   //check the current P(t+1)'s size
			{
				// put the current F into P(t+1)
				for(j=current_count;j<current_count+nrank[i];j++)
					P.individuals[j]=F.individuals[j-current_count];  
				current_count += nrank[i];
			}
			else
			{

				// to estimate the density of solutions srrounding a particular solution
				crowding_sort(F,TRUE);   

				int remain= population_size - current_count;
				for(j=current_count;j<current_count+remain;j++)
					P.individuals[j]=F.individuals[j-current_count];			
				current_count += remain;
			}
		}
	
		genNo++;
		f1.close();
		f2.close();
	}
if (nrank) {delete [] nrank; nrank=NULL;}    

}
