function [length_icefront,normal_icefront]=buildicefrontnormals(x,y,index_icefront);
%BUILDICEFRONTNORMALS - compute normals of the ice front
%
%   this routine builds the normal of the segments located on the ice front and calculates
%   the length of these segments.
%
%   Usage:
%      [length_icefront,normal_icefront]=buildicefrontnormals(index_icefront);

length_icefront=zeros(length(index_icefront),1);
normal_icefront=zeros(length(index_icefront),2);

length_icefront=sqrt( (x(index_icefront(:,1))-x(index_icefront(:,2))).^2 ...
	+ (y(index_icefront(:,1))-y(index_icefront(:,2))).^2 );

normal_icefront(:,1)=cos( ...
atan2( (x(index_icefront(:,1))-x(index_icefront(:,2))) , ...
		(y(index_icefront(:,2))-y(index_icefront(:,1))) ) ...
);

normal_icefront(:,2)=sin( ...
atan2( (x(index_icefront(:,1))-x(index_icefront(:,2))) , ...
		(y(index_icefront(:,2))-y(index_icefront(:,1))) ) ...
);
