function [x y z elements is2d]=processmesh(md,options_structure);
%PROCESSMESH - process mesh to be plotted
%
%   Usage:
%      [x y z elements is2d]=processmesh(md,options_structure)
%
%   See also: PLOTMODEL, PROCESSDATA

%some checks
if md.numberofgrids==md.numberofelements
	error('plot error message: the number of elements is the same as the number of grids! cannot plot anything with model/plot, use matlab/plot instead')
end

%first load x,y, etc ... to speed up plot
x=md.x;
x2d=md.x2d;
y=md.y;
y2d=md.y2d;
z=md.z;
z2d=md.z2d;
elements2d=md.elements2d;
elements=md.elements;
elements_type2d=md.elements_type2d;

%is it a 2d plot?
if strcmpi(md.type,'2d');
	is2d=1;
else
	if ~isnan(options_structure.layer) & options_structure.layer>=1,
		is2d=1;
	else
		is2d=0;
	end
end

%layer projection? 
if ~isnan(options_structure.layer) & options_structure.layer>=1,
	%we modify the mesh temporarily to a 2d mesh from which the 3d mesh was extruded. 
	x=x2d;
	y=y2d;
	z=z2d;
	elements=elements2d;
	elements_type=elements_type2d;
end

%units
if ~isnan(options_structure.unitmultiplier),
	x=x*options_structure.unitmultiplier;
	y=y*options_structure.unitmultiplier;
	z=z*options_structure.unitmultiplier;
end
