/* -*- Mode: C; c-basic-offset:4 ; -*- */
/*
 *  (C) 2001 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 */

#include "mpidi_ch3_impl.h"

MPIDI_CH3I_Process_t MPIDI_CH3I_Process;

#undef FUNCNAME
#define FUNCNAME MPIDI_CH3_Init
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPIDI_CH3_Init(int * has_args, int * has_env, int * has_parent, MPIDI_PG_t ** pg_pptr, int * pg_rank_ptr)
{
    int mpi_errno = MPI_SUCCESS;
    MPIDI_PG_t * pg = NULL;
    MPIDI_VC_t * vc = NULL;

    int pg_rank;
    int pg_size;
    int p;

    /* initialize the process group setting the rank and size */
    mpi_errno = MPIDI_CH3I_RDMA_init_process_group(has_parent, &pg, &pg_rank);
    if (mpi_errno != MPI_SUCCESS)
    {
	mpi_errno = MPIR_Err_create_code(mpi_errno, MPIR_ERR_FATAL, FCNAME, __LINE__, MPI_ERR_OTHER, "**process_group", 0);
	return mpi_errno;
    }

    pg_size = MPIDI_PG_Get_size(pg);

    /* Initialize the VC table associated with this process
       group (and thus COMM_WORLD) */
    for (p = 0; p < pg_size; p++)
    {
	MPIDI_PG_Get_vcr(pg, p, &vc);
	vc->ch.sendq_head = NULL;
	vc->ch.sendq_tail = NULL;
	vc->ch.req = (MPID_Request*)MPIU_Malloc(sizeof(MPID_Request));
	vc->ch.state = MPIDI_CH3I_VC_STATE_IDLE;
	vc->ch.read_state = MPIDI_CH3I_READ_STATE_IDLE;
	vc->ch.recv_active = NULL;
	vc->ch.send_active = NULL;
#ifdef USE_RDMA_UNEX
	vc->ch.unex_finished_next = NULL;
	vc->ch.unex_list = NULL;
#endif
    }

    /* save my vc_ptr for easy access */
    MPIDI_PG_Get_vcr(pg, pg_rank, &MPIDI_CH3I_Process.vc);

    /* Initialize Progress Engine */
    mpi_errno = MPIDI_CH3I_Progress_init();
    if (mpi_errno != MPI_SUCCESS)
    {
	mpi_errno = MPIR_Err_create_code(mpi_errno, MPIR_ERR_FATAL, FCNAME, __LINE__, MPI_ERR_OTHER, "**ch3_init", 0);
	return mpi_errno;
    }

    /* allocate rmda memory and set up the queues */
    mpi_errno = MPIDI_CH3I_RDMA_init();
    if (mpi_errno != MPI_SUCCESS)
    {
	mpi_errno = MPIR_Err_create_code(mpi_errno, MPIR_ERR_FATAL, FCNAME, __LINE__, MPI_ERR_OTHER, "**ch3_init", 0);
	return mpi_errno;
    }

    /* XXX - has_args and has_env need to come from PMI eventually... */
    *has_args = TRUE;
    *has_env = TRUE;

    *pg_pptr = pg;
    *pg_rank_ptr = pg_rank;

#if 0
    /* The rdma interface needs to be adjusted to be able to retrieve the PARENT_ROOT_PORT_NAME */
    /* If this code copied from the shm channel were used, it assumes that PMI is used in MPIDI_CH3I_RDMA_init_process_group */
    if (*has_parent)
    {
        /* This process was spawned. Create intercommunicator with parents. */

        if (pg_rank == 0)
	{
            /* get the port name of the root of the parents */
            mpi_errno = PMI_KVS_Get(pg->kvs_name, "PARENT_ROOT_PORT_NAME", val, val_max_sz);
            if (mpi_errno != 0)
            {
                mpi_errno = MPIR_Err_create_code(MPI_SUCCESS, MPIR_ERR_FATAL, FCNAME, __LINE__, MPI_ERR_OTHER, "**pmi_kvs_get", "**pmi_kvs_get_parent %d", mpi_errno);
                return mpi_errno;
            }
        }

        /* do a connect with the root */
        MPID_Comm_get_ptr(MPI_COMM_WORLD, commworld);
        mpi_errno = MPIDI_CH3_Comm_connect(val, 0, commworld, &intercomm);
        if (mpi_errno != MPI_SUCCESS)
	{
	    mpi_errno = MPIR_Err_create_code(mpi_errno, MPIR_ERR_FATAL, FCNAME, __LINE__, MPI_ERR_OTHER, "**fail", "**fail %s", "spawned group unable to connect back to the parent");
	    return mpi_errno;
	}

	MPIU_Strncpy(intercomm->name, "MPI_COMM_PARENT", MPI_MAX_OBJECT_NAME);
        MPIR_Process.comm_parent = intercomm;

        /* TODO: Check that this intercommunicator gets freed in
           MPI_Finalize if not already freed.  */
    }
#endif

    return MPI_SUCCESS;
}
