function globalmatrix = globalmatrix(varargin)
%GLOBALMATRIX - constructor for globalmatrix object
%
%   Usage:
%      globalmatrix = globalmatrix(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	globalmatrix.nrows=NaN;
	globalmatrix.matrix=NaN;
	
	globalmatrix=class(globalmatrix,'globalmatrix');
case 1
	%If single argument we have a copy constructor. 
	argument = varargin{1};
	if isa(argument,'globalmatrix'),
		globalmatrix=argument;
	else 
		if isnumeric(varargin{1}),
			numdof=argument;
			globalmatrix.nrows=numdof;
			globalmatrix.matrix=sparse(numdof,numdof,0);

			globalmatrix=class(globalmatrix,'globalmatrix');
		elseif isstruct(argument),
			globalmatrix=class(argument,'globalmatrix');
		else
			error('elemmmatrix constructor error message: invalid input argument');
		end
	end
otherwise
	error('globalmatrix constructor error message: 0 of 1 argument only in input.');
end
