#!/bin/bash

#This shell tries to synchronize the current cielo root directory on another 
#machine. 

echo "Watch out, this script should be run in top level directory of cielo"

echo -n "Platform (cosmos,mustang,gemini)?: "
read platform 


if [[ "$platform" ==  "cosmos" ]]
then
	echo "Synchronizing cielo with cosmos"
	#first cleanup the archive
	cl
	clb
	cls
	#then tar the archive
	present_directory=`pwd`;
	cd ../
	rm -rf trunk.tar.gz
	tar zcvf trunk.tar.gz trunk

	#send archive to cosmos
	scp  trunk.tar.gz larour@cosmos.jpl.nasa.gov:/home/larour

	#run synchronization script on cosmos
	ssh larour@cosmos.jpl.nasa.gov './sync_cosmos.sh'

	rm -rf trunk.tar.gz
elif [[ "$platform" ==  "mustang" ]]
then
	
	echo "Synchronizing cielo with mustang"
	#first cleanup the archive
	cl
	clb
	cls
	#then tar the archive
	present_directory=`pwd`;
	cd ../
	rm -rf trunk.tar.gz
	tar zcvf trunk.tar.gz trunk

	#send archive to mustang
	scp  trunk.tar.gz larour@mustang.jpl.nasa.gov:/proj/ice/larour/Ice/

	#run synchronization script on cosmos
	ssh larour@mustang.jpl.nasa.gov './sync_mustang.sh'

	rm -rf trunk.tar.gz
elif [[ "$platform" ==  "gemini" ]]
then
	echo "Synchronizing cielo with gemini"
	
	#first cleanup the archive
	make -f MakefileIce clean
	make clean 
	cd doc
	make -f MakefileIce clean
	cd ..

	#erase packages symlink
	rm -rf packages 
	cvs update -d -P packages
	
	#then tar the archive
	make dist-gzip

	#send archive to cosmos
	scp  issm-1.0.tar.gz larour@gemini.jpl.nasa.gov:/home/larour

	#run synchronization script on cosmos
	ssh larour@gemini.jpl.nasa.gov './sync_gemini.sh'

	rm -rf issm-1.0.tar.gz

	#relink packages
	rm -rf packages
	ln -s ../packages packages

else
	echo "This platform not supported yet"
	exit
fi
