/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:        ParamResponsePair
//- Description:  Class implementation
//- Owner:        Mike Eldred

#include "ParamResponsePair.H"

static const char rcsId[]="@(#) $Id";


namespace Dakota {

ParamResponsePair::ParamResponsePair(const ParamResponsePair& pair)
{
  prPairParameters = pair.prPairParameters;
  idInterface      = pair.idInterface;
  prPairResponse   = pair.prPairResponse;
  evalId           = pair.evalId;
}


ParamResponsePair& ParamResponsePair::operator=(const ParamResponsePair& pair)
{
  prPairParameters = pair.prPairParameters;
  idInterface      = pair.idInterface;
  prPairResponse   = pair.prPairResponse;
  evalId           = pair.evalId;

  return *this;
}


void ParamResponsePair::read_annotated(istream& s)
{
  prPairParameters.read_annotated(s);
  s >> idInterface;
  if (idInterface == "NULL")
    idInterface.clear();
  prPairResponse.read_annotated(s);
  s >> evalId;
}


void ParamResponsePair::write_annotated(ostream& s) const
{
  prPairParameters.write_annotated(s);
  if (idInterface.empty())
    s << "NULL "; // read_annotated cannot detect an empty string
  else 
    s << idInterface << ' ';
  prPairResponse.write_annotated(s);
  s << evalId << '\n';
}


void ParamResponsePair::write_tabular(ostream& s) const
{
  s << setw(8) << evalId << ' ';
  prPairParameters.write_tabular(s);
  prPairResponse.write_tabular(s);
}

} // namespace Dakota
