#!/bin/bash

#go to the main directory
cd $ISSM_DIR

#launch matlab
matlab -nojvm << EOF
%get ISSM_DIR, brief name
[status,ISSM_DIR_BRIEF]=system('basename `pwd`');
ISSM_DIR_BRIEF=ISSM_DIR_BRIEF(1:end-1); %skip the \n character
if status~=0 | isempty(ISSM_DIR_BRIEF) | length(ISSM_DIR_BRIEF)==1,
	error('startup error message: could not retrieve ISSM_DIR brief name');
	end

	cd ../

	%Here are the subdirectories we want to go through:
	mfiles={[ISSM_DIR_BRIEF '/src/m']};

	%run m2html, and dump the documentation in ISSM_DIR/Doc/developerguide/m2htmldoc
	m2html('htmldir',[ISSM_DIR '/doc/developerguide/matlabhtml'],'recursive','on','source','on','syntaxHighlighting','on','globalHypertextLinks','on','global','on','template','frame', 'index','menu','mFiles',mfiles);
EOF
