function areas=area(md)
%AREA - compute areas for every element
%
%   Usage:
%      areas=area(md)

areas=zeros(md.numberofelements,1);

%load some variables (it is much faster if the variab;es are loaded from md once for all)
index=md.elements;
x=md.x; y=md.y; z=md.z;
x1=x(index(:,1)); x2=x(index(:,2)); x3=x(index(:,3)); y1=y(index(:,1)); y2=y(index(:,2)); y3=y(index(:,3));

%compute the volume of each element
if strcmpi(md.type,'3d')
	%V=area(triangle)*1/3(z1+z2+z3)
	thickness=mean(z(index(:,4:6)))-mean(z(index(:,1:3)));
	areas=abs(0.5*((x2-x1).*(y3-y1)-(y2-y1).*(x3-x1)));
else
	%compute the surface of the triangle
	areas=abs(0.5*((x2-x1).*(y3-y1)-(y2-y1).*(x3-x1)));
end
