function icefront = icefront(varargin)
%ICEFRONT - constructor for icefront object
%
%   Usage:
%      icefront = icefront(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	icefront.eid=NaN;
	icefront.g=zeros(4,1);
	icefront.rho_water=NaN;
	icefront.type='segment'; %segment or quad, depending on whether we are running '2d' or '3d'
	icefront=class(icefront,'icefront');
case 1
	%If single argument of class icefront, we have a copy constructor. 
	if (isa(varargin{1},'icefront'))
		icefront = varargin{1};
	else
		error('icefront constructor error message: copy constructor called on a non ''icefront'' class object');
	end 
otherwise
	error('icefront constructor error message: 0 of 1 argument only in input.');
end
