function p_f= IceReducerightside( p_g, G_mn, K_fs, y_s)
%ICEREDUCERIGHTSIDE - reduce load vector from g to f
%
%   Usage:
%      p_f= IceReducerightside( p_g, G_mn, K_fs, y_s)

global gridset
	
% Reduce p_g to p_f 
% Reduce p_g to p_n
if ( gridset.msize > 0 )
	p_n = p_g( gridset.pv_n, :);
	p_m = p_g( gridset.pv_m, :);
	p_n = p_n + G_mn' * p_m;
else
	p_n  = p_g;
end

% Reduce p_n to p_f
if ( gridset.ssize > 0 )
	p_f = p_n( gridset.pv_f, :);
else
	p_f = p_n;
end
		
% for nonzero boundary conditions, subtract coupling forces,
% this operation is only executed if flag_y_s > 0,
% the flag is set in the calling script for linear analysis
% and the first iteration step in nonlinear analysis
if ~isempty(y_s)
	p_f = p_f - K_fs * y_s;
end
