/* -*- Mode: C; c-basic-offset:4 ; -*- */
/*  $Id: printdlog.c,v 1.5 2002/09/27 21:11:13 toonen Exp $
 *
 *  (C) 2001 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 */

#include "dlog.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

void PrintRecord(DLOG_IOStruct *pInput)
{
    printf("%9.5f %d:", pInput->header.timestamp, pInput->header.procid);

    switch (pInput->header.type)
    {
    case DLOG_EVENT_TYPE:
	printf("DLOG_EVENT  -");
	printf(" %4d, start: %10g, end: %10g\n", pInput->record.event.event, pInput->record.event.start_time, pInput->record.event.end_time);
	break;
    case DLOG_OPEN_EVENT_TYPE:
	printf("DLOG_OEVENT -");
	printf(" %4d, data: %d\n", pInput->record.oevent.event, pInput->record.oevent.data);
	break;
    case DLOG_ARROW_TYPE:
	printf("DLOG_ARROW  -");
	printf(" %4d, data: %d, tag: %d, length: %d\n", pInput->record.arrow.event, pInput->record.arrow.data, pInput->record.arrow.tag, pInput->record.arrow.length);
	break;
    case DLOG_COMM_TYPE:
	printf("DLOG_COMM   -");
	printf(" %4d, newcomm: %d\n", pInput->record.comm.etype, pInput->record.comm.newcomm);
	break;
    case DLOG_OPEN_STATE_TYPE:
	printf("DLOG_OSTATE -");
	printf(" id: %d, [%d:%d],%20s : %s\n", 
	    pInput->record.ostate.stateid, 
	    pInput->record.ostate.startetype, 
	    pInput->record.ostate.endetype, 
	    pInput->record.ostate.color, 
	    pInput->record.ostate.description);
	break;
    case DLOG_STATE_TYPE:
	printf("DLOG_STATE  -");
	printf(" id: %d, %20s : %s\n", pInput->record.state.stateid, pInput->record.state.color, pInput->record.state.description);
	break;
    case DLOG_ENDLOG_TYPE:
	printf("DLOG_ENDLOG\n");
	break;
    default:
	printf("unknown record type %d\n", pInput->header.type);
    }
}

#define ARRAY_SIZE 1024*1024

int main(int argc, char *argv[])
{
    int nNumInputs = 0;
    DLOG_IOStruct *pInput = NULL;
    int rec_type;
    int bAllRecords = 1;
    int bExcludeType = 0;
    double dLast;
    int bValidate = 0;
    /*
    int *aEvent;
    int i;
    */

    if (argc < 2)
    {
	printf("%s clogfile [REC_TYPE]\n", argv[0]);
	return -1;
    }

    pInput = DLOG_CreateInputStruct(argv[1]);
    if (pInput == NULL)
    {
	printf("Error setting up file '%s'\n", argv[1]);
	return -1;
    }

    if (argc > 2)
    {
	if (strcmp(argv[2], "DLOG_EVENT") == 0)
	{
	    bAllRecords = 0;
	    rec_type = DLOG_EVENT_TYPE;
	}
	if (strcmp(argv[2], "DLOG_OPEN_EVENT") == 0)
	{
	    bAllRecords = 0;
	    rec_type = DLOG_OPEN_EVENT_TYPE;
	}
	if (strcmp(argv[2], "DLOG_ARROW") == 0)
	{
	    bAllRecords = 0;
	    rec_type = DLOG_ARROW_TYPE;
	}
	if (strcmp(argv[2], "DLOG_STATE") == 0)
	{
	    bAllRecords = 0;
	    rec_type = DLOG_STATE_TYPE;
	}
	if (strcmp(argv[2], "DLOG_OSTATE") == 0)
	{
	    bAllRecords = 0;
	    rec_type = DLOG_OPEN_STATE_TYPE;
	}
	if (strcmp(argv[2], "DLOG_COMM") == 0)
	{
	    bAllRecords = 0;
	    rec_type = DLOG_COMM_TYPE;
	}
	if (strcmp(argv[2], "DLOG_ENDLOG") == 0)
	{
	    bAllRecords = 0;
	    rec_type = DLOG_ENDLOG_TYPE;
	}
	if (strcmp(argv[2], "validate") == 0)
	{
	    bValidate = 1;
	}
    }
    if (argc > 3)
    {
	if (strcmp(&argv[3][1], "exclude") == 0)
	    bExcludeType = 1;
    }

    dLast = 0.0;
    /*
    if (bValidate)
    {
	aEvent = (int*)malloc(ARRAY_SIZE * sizeof(int));
	for (i=0; i<ARRAY_SIZE; i++)
	    aEvent[i] = 0;
    }
    */

    while (1)
    {
	if (bValidate)
	{
	    if (pInput->header.type == DLOG_OPEN_EVENT_TYPE)
	    {
		if (dLast > pInput->header.timestamp)
		{
		    printf("out of order: %g > %g\n", dLast, pInput->header.timestamp);
		}
		dLast = pInput->header.timestamp;
		/*
		if (pInput->record.oevent.event < 0 || pInput->record.oevent.event > ARRAY_SIZE)
		    printf(".");
		else
		    aEvent[pInput->record.oevent.event]++;
		    */
	    }
	}
	else if (bExcludeType)
	{
	    if (pInput->header.type != rec_type)
		PrintRecord(pInput);
	}
	else
	{
	    if ((bAllRecords) || (pInput->header.type == rec_type))
		PrintRecord(pInput);
	}
	if (DLOG_GetNextRecord(pInput))
	{
	    DLOG_CloseInputStruct(&pInput);
	    break;
	}
    }

    /*
    if (bValidate)
    {
	for (i=0; i<ARRAY_SIZE; i++)
	{
	    if (aEvent[i] > 0)
	    {
		printf("event %d: %d\n", i, aEvent[i]);
	    }
	}
	free(aEvent);
    }
    */

    return 0;
}
