#ifndef _MAINEFFECTS3ANALYZERH_
#define _MAINEFFECTS3ANALYZERH_

#ifdef HAVE_CONFIG_H
#include "ddace_config.h"
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_STD
#include <cstdlib>
#else
#include <stdlib.h>
#endif /* HAVE_STD */

#include <string>
#ifdef HAVE_SSTREAM
#include <sstream>
#endif /* HAVE_SSTREAM */
using namespace std;

/**
 * Changes:	Added consts to make functions safer.
 *		moved ctors from .cpp to .h
**/

class ColumnHeader {
public:

	// Added const. Also set variables in .h file instead of .cpp
        static std::string FACTOR;
        static std::string RESPONSE;


	ColumnHeader() {};
        ColumnHeader(std::string n, std::string u, std::string f) :
		title(n), 
		abbreviatedTitle(computeAbbreviatedTitle(n)), 
		factorOrResponse(f),
		name(n), 
		units(u)
	 {};

        std::string getTitle() const { return title; };
        void setTitle(const std::string t) { title = t; };

        std::string getAbbreviatedTitle() const { return abbreviatedTitle; };

        void setAbbreviatedTitle(const std::string t) { abbreviatedTitle = t;};

        std::string getFactorOrResponse() const { return factorOrResponse; };
        void setFactorOrResponse(const std::string f) { factorOrResponse = f; }

        std::string computeAbbreviatedTitle(std::string title);

private:
        std::string title;
        std::string abbreviatedTitle;
        std::string factorOrResponse;

        std::string name;
        std::string units;
};


#endif
