C***********************************************************************
C LHS (Latin Hypercube Sampling) UNIX Library/Standalone. 
C Copyright (c) 2004, Sandia Corporation.  Under the terms of Contract
C DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government
C retains certain rights in this software.
C
C This software is distributed under the GNU General Public License.
C For more information, see the README file in the LHS directory. 
C***********************************************************************
C     Last change:  SLD   5 Dec 96    2:22 pm
C
C               Here is the original include file
C
c============================================================================
c============================================================================
cC     -- THIS INCLUDE BLOCK CONTAINS THE NAMES AND LENGTHS OF THE
cC     -- DISTRIBUTION NAMES
c      PARAMETER (LEND=37, MAXPAR=4)
c      DIMENSION IDSST(LEND), IDSEND(LEND), IDSPAR(LEND)
c      CHARACTER*505 DIST
cC
cC     --- THE PARAMETER LEND IS THE TOTAL NUMBER OF DISTRIBUTIONS THAT
cC     --- ARE DEFINED IN THE LHS PROGRAM.
cC
cC     --- THE PARAMETER MAXPAR IS THE MAXIMUM NUMBER OF PARAMETERS THAT
cC     --- ANY DISTRIBUTION ***WITH A KNOWN NUMBER OF PARAMETERS*** MUST
cC     --- BE ABLE TO READ.  CURRENTLY IT IS SET TO 4 FOR THE BETA
cC     --- AND TRUNCATED AND BOUNDED NORMAL/LOGNORMAL DISTRIBUTIONS
cC
cC     --- THE CHARACTER CONSTANT DIST CONTAINS ALL CHARACTER DISTRIBUTION
cC     --- NAMES, SEPARATED BY SPACES.
cC
cC     --- THE INTEGER ARRAY IDSST(I) IS A POINTER TO THE FIRST CHARACTER
cC     --- IN THE I-TH DISTRIBUTION NAME.
cC
cC     --- IDSEND(I) POINTS TO THE SPACE AT THE END OF THE I-TH DISTRIBUTION
cC     --- NAME.
cC
cC     --- IDSPAR(I) TELLS RDPAR HOW TO READ THE PARAMETERS FOR THE
cC     --- I-TH DISTRIBUTION BY THE FOLLOWING METHOD:
cC
cC           IDSPAR(I) > 0    EXACTLY IDSPAR(I) PARAMETERS ARE REQUIRED FOR
cC                            THE DISTRIBUTION.  EXTRA PARAMETERS ARE IGNORED.
cC
cC           IDSPAR(I) = -1   AN UNKNOWN NUMBER OF PARAMETERS MUST BE READ
cC                            ACCORDING TO THE RULES USED FOR UNIFORM*
cC
cC           IDSPAR(I) = -2   AN UNKNOWN NUMBER OF PARAMETERS MUST BE READ
cC                            ACCORDING TO THE RULES USED FOR USER-DEFINED
cC                            CUMULATIVE, DENSITY, AND HISTOGRAM FUNCTIONS
cC
cC     --- THE DISTRIBUTION NUMBERS DEFINED HERE ARE USED IN THE MAIN LHS
cC     --- PROGRAM TO DETERMINE WHICH SUBROUTINE IS CALLED TO GENERATE THE
cC     --- REQUIRED DISTRIBUTION.
cC
cC
cC     -- DISTRIBUTION 1 - BETA - 4 PARAMETERS
c      DATA DIST(1:5)     /'BETA '/,
c     1     IDSST(1)  /   1 /, IDSEND(1)  /   5 /, IDSPAR(1)  /  4 /
cC
cC     -- DISTRIBUTION 2 - NORMAL - 2 PARAMETERS
c      DATA DIST(6:12)    /'NORMAL '/,
c     2     IDSST(2)  /   6 /, IDSEND(2)  /  12 /, IDSPAR(2)  /  2 /
cC
cC     -- DISTRIBUTION 3 - LOGNORMAL - 2 PARAMETERS
c      DATA DIST(13:22)   /'LOGNORMAL '/,
c     3     IDSST(3)  /  13 /, IDSEND(3)  /  22 /, IDSPAR(3)  /  2 /
cC
cC     -- DISTRIBUTION 4 - UNIFORM - 2 PARAMETERS
c      DATA DIST(23:30)   /'UNIFORM '/,
c     4     IDSST(4)  /  23 /, IDSEND(4)  /  30 /, IDSPAR(4)  /  2 /
cC
cC     -- DISTRIBUTION 5 - LOGUNIFORM - 2 PARAMETERS
c      DATA DIST(31:41)   /'LOGUNIFORM '/,
c     5     IDSST(5)  /  31 /, IDSEND(5)  /  41 /, IDSPAR(5)  /  2 /
cC
cC     -- DISTRIBUTION 6 - PIECEWISE UNIFORM - MANY PARAMETERS TYPE 1
c      DATA DIST(42:50)   /'UNIFORM* '/,
c     6     IDSST(6)  /  42 /, IDSEND(6)  /  50 /, IDSPAR(6)  / -1 /
cC
cC     -- DISTRIBUTION 7 - PIECEWISE LOGUNIFORM - MANY PARAMETERS TYPE 1
c      DATA DIST(51:62)   /'LOGUNIFORM* '/,
c     7     IDSST(7)  /  51 /, IDSEND(7)  /  62 /, IDSPAR(7)  / -1 /
cC
cC     -- DISTRIBUTION 8 - TRIANGULAR - 3 PARAMETERS
c      DATA DIST(63:73)   /'TRIANGULAR '/,
c     8     IDSST(8)  /  63 /, IDSEND(8)  /  73 /, IDSPAR(8)  /  3 /
cC
cC     -- DISTRIBUTION 9 - CONTINUOUS USER DEFINED WITH LINEAR INTERPOLATION
cC     --                - MANY PARAMETERS TYPE 2
c      DATA DIST(74:91)   /'CONTINUOUS LINEAR '/,
c     9     IDSST(9)  /  74 /, IDSEND(9)  /  91 /, IDSPAR(9)  / -2 /
cC
cC     -- DISTRIBUTION 10 - CONTINUOUS USER DEFINED WITH LOGARITHMIC
cC     --                   INTERPOLATION - MANY PARAMETERS TYPE 2
c      DATA DIST(92:114)  /'CONTINUOUS LOGARITHMIC '/,
c     *     IDSST(10) /  92 /, IDSEND(10) / 114 /, IDSPAR(10) / -2 /
cC
cC     -- DISTRIBUTION 11 - CONTINUOUS USER DEFINED WITH DENSITY FUNCTION INPUT
cC     --                 - MANY PARAMETERS TYPE 2
c      DATA DIST(115:135) /'CONTINUOUS FREQUENCY '/,
c     1     IDSST(11) / 115 /, IDSEND(11) / 135 /, IDSPAR(11) / -2 /
cC
cC     -- DISTRIBUTION 12 - DISCRETE USER DEFINED CUMULATIVE DISTRIBUTION
cC     --                 - MANY PARAMETERS TYPE 2
c      DATA DIST(136:155) /'DISCRETE CUMULATIVE '/,
c     2     IDSST(12) / 136 /, IDSEND(12) / 155 /, IDSPAR(12) / -2 /
cC
cC     -- DISTRIBUTION 13 - DISCRETE USER DEFINED HISTOGRAM DISTRIBUTION
cC     --                 - MANY PARAMETERS TYPE 2
c      DATA DIST(156:174) /'DISCRETE HISTOGRAM '/,
c     3     IDSST(13) / 156 /, IDSEND(13) / 174 /, IDSPAR(13) / -2 /
cC
cC     -- DISTRIBUTION 14 - POISSON (DISCRETE) - 1 PARAMETER
c      DATA DIST(175:182) /'POISSON '/,
c     4     IDSST(14) / 175 /, IDSEND(14) / 182 /, IDSPAR(14) /  1 /
cC
cC     -- DISTRIBUTION 15 - GEOMETRIC (DISCRETE) - 1 PARAMETER
c      DATA DIST(183:192) /'GEOMETRIC '/,
c     5     IDSST(15) / 183 /, IDSEND(15) / 192 /, IDSPAR(15) /  1 /
cC
cC     -- DISTRIBUTION 16 - BINOMIAL (DISCRETE) - 2 PARAMETERS
c      DATA DIST(193:201) /'BINOMIAL '/,
c     6     IDSST(16) / 193 /, IDSEND(16) / 201 /, IDSPAR(16) /  2 /
cC
cC     -- DISTRIBUTION 17 - NEGATIVE BINOMIAL (DISCRETE) - 2 PARAMETERS
c      DATA DIST(202:219) /'NEGATIVE BINOMIAL '/,
c     7     IDSST(17) / 202 /, IDSEND(17) / 219 /, IDSPAR(17) /  2 /
cC
cC     -- DISTRIBUTION 18 - HYPERGEOMETRIC (DISCRETE) - 3 PARAMETERS
c      DATA DIST(220:235) /'HYPERGEOMETRIC  '/,
c     8     IDSST(18) / 220 /, IDSEND(18) / 234 /, IDSPAR(18) /  3 /
cC
cC     -- DISTRIBUTION 19 - EXPONENTIAL - 1 PARAMETER
c      DATA DIST(236:247) /'EXPONENTIAL '/
c     9     IDSST(19) / 236 /, IDSEND(19) / 247 /, IDSPAR(19) /  1 /
cC
cC     -- DISTRIBUTION 20 - WEIBULL - 2 PARAMETERS
c      DATA DIST(248:255) /'WEIBULL '/,
c     *     IDSST(20) / 248 /, IDSEND(20) / 255 /, IDSPAR(20) /  2 /
cC
cC     -- DISTRIBUTION 21 - PARETO - 2 PARAMETERS
c      DATA DIST(256:262) /'PARETO '/,
c     1     IDSST(21) / 256 /, IDSEND(21) / 262 /, IDSPAR(21) /  2 /
cC
cC     -- DISTRIBUTION 22 - GAMMA - 2 PARAMETERS
c      DATA DIST(263:268) /'GAMMA '/,
c     2     IDSST(22) / 263 /, IDSEND(22) / 268 /, IDSPAR(22) /  2 /
cC
cC     -- DISTRIBUTION 23 - INVERSE GAUSSIAN - 2 PARAMETERS
c      DATA DIST(269:285) /'INVERSE GAUSSIAN '/,
c     3     IDSST(23) / 269 /, IDSEND(23) / 285 /, IDSPAR(23) /  2 /
cC
cC     -- DISTRIBUTION 24 - MAXIMUM ENTROPY - 3 PARAMETERS
c      DATA DIST(286:301)/'MAXIMUM ENTROPY '/,
c     4     IDSST(24) / 286 /, IDSEND(24) / 301 /, IDSPAR(24) /  3 /
cC
cC     -- DISTRIBUTION 25 - TRUNCATED EXPONENTIAL - 3 PARAMETERS
c      DATA DIST(302:323)/'TRUNCATED EXPONENTIAL '/,
c     4     IDSST(25) / 302 /, IDSEND(25) / 323 /, IDSPAR(25) /  3 /
cC
cC     -- DISTRIBUTION 26 - BOUNDED EXPONENTIAL - 3 PARAMETERS
c      DATA DIST(324:343)/'BOUNDED EXPONENTIAL '/,
c     4     IDSST(26) / 324 /, IDSEND(26) / 343 /, IDSPAR(26) /  3 /
cC
cC     -- DISTRIBUTION 27 - NORMAL-B - 2 PARAMETERS
c      DATA DIST(344:352)/'NORMAL-B '/,
c     4     IDSST(27) / 344 /, IDSEND(27) / 352 /, IDSPAR(27) /  2 /
cC
cC     -- DISTRIBUTION 28 - LOGNORMAL-B - 2 PARAMETERS
c      DATA DIST(353:364)/'LOGNORMAL-B '/,
c     4     IDSST(28) / 353 /, IDSEND(28) / 364 /, IDSPAR(28) /  2 /
cC
cC     -- DISTRIBUTION 29 - LOGNORMAL-N - 2 PARAMETERS
c      DATA DIST(365:376)/'LOGNORMAL-N '/,
c     4     IDSST(29) / 365 /, IDSEND(29) / 376 /, IDSPAR(29) /  2 /
cC
cC     -- DISTRIBUTION 30 - BOUNDED NORMAL - 4 PARAMETERS
c      DATA DIST(377:391)/'BOUNDED NORMAL '/,
c     4     IDSST(30) / 377 /, IDSEND(30) / 391 /, IDSPAR(30) /  4 /
cC
cC     -- DISTRIBUTION 31 - TRUNCATED NORMAL - 4 PARAMETERS
c      DATA DIST(392:408)/'TRUNCATED NORMAL '/,
c     4     IDSST(31) / 392 /, IDSEND(31) / 408 /, IDSPAR(31) /  4 /
cC
cC     -- DISTRIBUTION 32 - BOUNDED LOGNORMAL - 4 PARAMETERS
c      DATA DIST(409:426)/'BOUNDED LOGNORMAL '/,
c     4     IDSST(32) / 409 /, IDSEND(32) / 426 /, IDSPAR(32) /  4 /
cC
cC     -- DISTRIBUTION 33 - TRUNCATED LOGNORMAL - 4 PARAMETERS
c      DATA DIST(427:446)/'TRUNCATED LOGNORMAL '/,
c     4     IDSST(33) / 427 /, IDSEND(33) / 446 /, IDSPAR(33) /  4 /
cC
cC     -- DISTRIBUTION 34 - BOUNDED LOGNORMAL-N - 4 PARAMETERS
c      DATA DIST(447:466)/'BOUNDED LOGNORMAL-N '/,
c     4     IDSST(34) / 447 /, IDSEND(34) / 466 /, IDSPAR(34) /  4 /
cC
cC     -- DISTRIBUTION 35 - TRUNCATED LOGNORMAL-N - 4 PARAMETERS
c      DATA DIST(467:488)/'TRUNCATED LOGNORMAL-N '/,
c     4     IDSST(35) / 467 /, IDSEND(35) / 488 /, IDSPAR(35) /  4 /
cC
cC     -- DISTRIBUTION 36 - GUMBEL - 2 PARAMETERS
c      DATA DIST(489:495)/'GUMBEL '/,
c     4     IDSST(36) / 489 /, IDSEND(36) / 495 /, IDSPAR(36) /  2 /
cC
cC     -- DISTRIBUTION 37 - FRECHET - 2 PARAMETERS
c      DATA DIST(496:503)/'FRECHET '/,
c     4     IDSST(37) / 496 /, IDSEND(37) / 503 /, IDSPAR(37) /  2 /
c
c============================================================================
c============================================================================
c
c               Now here is the module implementation
c
      MODULE DISTNM
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        INTEGER, PARAMETER :: LEND=37, MAXPAR=4
        INTEGER, ALLOCATABLE :: IDSST(:), IDSEND(:), IDSPAR(:)
        CHARACTER (LEN=505) :: DIST
C
C       Now here is the initialization routine for this module
      CONTAINS
C
      SUBROUTINE DISTNM_INIT()
C
        ALLOCATE( IDSST(LEND), IDSEND(LEND), IDSPAR(LEND) )
        IDSST = 0
        IDSEND = 0
        IDSPAR = 0
C
C     -- DISTRIBUTION 1 - BETA - 4 PARAMETERS
        DIST(1:5) = 'BETA '
        IDSST(1) = 1
        IDSEND(1) = 5
        IDSPAR(1) = 4
C
C     -- DISTRIBUTION 2 - NORMAL - 2 PARAMETERS
        DIST(6:12) = 'NORMAL '
        IDSST(2) = 6
        IDSEND(2) = 12
        IDSPAR(2) = 2
C
C     -- DISTRIBUTION 3 - LOGNORMAL - 2 PARAMETERS
        DIST(13:22) = 'LOGNORMAL '
        IDSST(3) = 13
        IDSEND(3) = 22
        IDSPAR(3) = 2
C
C     -- DISTRIBUTION 4 - UNIFORM - 2 PARAMETERS
        DIST(23:30) = 'UNIFORM '
        IDSST(4) =   23
        IDSEND(4) =   30
        IDSPAR(4) =   2
C
C     -- DISTRIBUTION 5 - LOGUNIFORM - 2 PARAMETERS
        DIST(31:41)  = 'LOGUNIFORM '
        IDSST(5) =   31
        IDSEND(5) =   41
        IDSPAR(5) =   2
C
C     -- DISTRIBUTION 6 - PIECEWISE UNIFORM - MANY PARAMETERS TYPE 1
        DIST(42:50)  = 'UNIFORM* '
        IDSST(6) =   42
        IDSEND(6) =   50
        IDSPAR(6) =  -1
C
C     -- DISTRIBUTION 7 - PIECEWISE LOGUNIFORM - MANY PARAMETERS TYPE 1
        DIST(51:62)  = 'LOGUNIFORM* '
        IDSST(7) =   51
        IDSEND(7) =   62
        IDSPAR(7) =  -1
C
C     -- DISTRIBUTION 8 - TRIANGULAR - 3 PARAMETERS
        DIST(63:73)  = 'TRIANGULAR '
        IDSST(8) =   63
        IDSEND(8) =   73
        IDSPAR(8) =   3
C
C     -- DISTRIBUTION 9 - CONTINUOUS USER DEFINED WITH LINEAR INTERPOLATION
C     --                - MANY PARAMETERS TYPE 2
        DIST(74:91)  = 'CONTINUOUS LINEAR '
        IDSST(9) =   74
        IDSEND(9) =   91
        IDSPAR(9) =  -2
C
C     -- DISTRIBUTION 10 - CONTINUOUS USER DEFINED WITH LOGARITHMIC
C     --                   INTERPOLATION - MANY PARAMETERS TYPE 2
        DIST(92:114) = 'CONTINUOUS LOGARITHMIC '
        IDSST(10) =  92
        IDSEND(10) = 114
        IDSPAR(10) = -2
C
C     -- DISTRIBUTION 11 - CONTINUOUS USER DEFINED WITH DENSITY FUNCTION INPUT
C     --                 - MANY PARAMETERS TYPE 2
        DIST(115:135)  = 'CONTINUOUS FREQUENCY '
        IDSST(11) = 115
        IDSEND(11) = 135
        IDSPAR(11) = -2
C
C     -- DISTRIBUTION 12 - DISCRETE USER DEFINED CUMULATIVE DISTRIBUTION
C     --                 - MANY PARAMETERS TYPE 2
        DIST(136:155)  = 'DISCRETE CUMULATIVE '
        IDSST(12) = 136
        IDSEND(12) = 155
        IDSPAR(12) = -2
C
C     -- DISTRIBUTION 13 - DISCRETE USER DEFINED HISTOGRAM DISTRIBUTION
C     --                 - MANY PARAMETERS TYPE 2
        DIST(156:174)  = 'DISCRETE HISTOGRAM '
        IDSST(13) = 156
        IDSEND(13) = 174
        IDSPAR(13) = -2
C
C     -- DISTRIBUTION 14 - POISSON (DISCRETE) - 1 PARAMETER
        DIST(175:182)  = 'POISSON '
        IDSST(14) = 175
        IDSEND(14) = 182
        IDSPAR(14) =  1
C
C     -- DISTRIBUTION 15 - GEOMETRIC (DISCRETE) - 1 PARAMETER
        DIST(183:192)  = 'GEOMETRIC '
        IDSST(15) = 183
        IDSEND(15) = 192
        IDSPAR(15) =  1
C
C     -- DISTRIBUTION 16 - BINOMIAL (DISCRETE) - 2 PARAMETERS
        DIST(193:201)  = 'BINOMIAL '
        IDSST(16) = 193
        IDSEND(16) = 201
        IDSPAR(16) =  2
C
C     -- DISTRIBUTION 17 - NEGATIVE BINOMIAL (DISCRETE) - 2 PARAMETERS
        DIST(202:219)  = 'NEGATIVE BINOMIAL '
        IDSST(17) = 202
        IDSEND(17) = 219
        IDSPAR(17) =  2
C
C     -- DISTRIBUTION 18 - HYPERGEOMETRIC (DISCRETE) - 3 PARAMETERS
        DIST(220:235)  = 'HYPERGEOMETRIC  '
        IDSST(18) = 220
        IDSEND(18) = 234
        IDSPAR(18) =  3
C
C     -- DISTRIBUTION 19 - EXPONENTIAL - 1 PARAMETER
        DIST(236:247)  = 'EXPONENTIAL '
        IDSST(19) = 236
        IDSEND(19) = 247
        IDSPAR(19) =  1
C
C     -- DISTRIBUTION 20 - WEIBULL - 2 PARAMETERS
        DIST(248:255)  = 'WEIBULL '
        IDSST(20) = 248
        IDSEND(20) = 255
        IDSPAR(20) =  2
C
C     -- DISTRIBUTION 21 - PARETO - 2 PARAMETERS
        DIST(256:262)  = 'PARETO '
        IDSST(21) = 256
        IDSEND(21) = 262
        IDSPAR(21) =  2
C
C     -- DISTRIBUTION 22 - GAMMA - 2 PARAMETERS
        DIST(263:268)  = 'GAMMA '
        IDSST(22) = 263
        IDSEND(22) = 268
        IDSPAR(22) =  2
C
C     -- DISTRIBUTION 23 - INVERSE GAUSSIAN - 2 PARAMETERS
        DIST(269:285)  = 'INVERSE GAUSSIAN '
        IDSST(23) = 269
        IDSEND(23) = 285
        IDSPAR(23) =  2
C
C     -- DISTRIBUTION 24 - MAXIMUM ENTROPY - 3 PARAMETERS
        DIST(286:301) = 'MAXIMUM ENTROPY '
        IDSST(24) = 286
        IDSEND(24) = 301
        IDSPAR(24) =  3
C
C     -- DISTRIBUTION 25 - TRUNCATED EXPONENTIAL - 3 PARAMETERS
        DIST(302:323) = 'TRUNCATED EXPONENTIAL '
        IDSST(25) = 302
        IDSEND(25) = 323
        IDSPAR(25) =  3
C
C     -- DISTRIBUTION 26 - BOUNDED EXPONENTIAL - 3 PARAMETERS
        DIST(324:343) = 'BOUNDED EXPONENTIAL '
        IDSST(26) = 324
        IDSEND(26) = 343
        IDSPAR(26) =  3
C
C     -- DISTRIBUTION 27 - NORMAL-B - 2 PARAMETERS
        DIST(344:352) = 'NORMAL-B '
        IDSST(27) = 344
        IDSEND(27) = 352
        IDSPAR(27) =  2
C
C     -- DISTRIBUTION 28 - LOGNORMAL-B - 2 PARAMETERS
        DIST(353:364) = 'LOGNORMAL-B '
        IDSST(28) = 353
        IDSEND(28) = 364
        IDSPAR(28) =  2
C
C     -- DISTRIBUTION 29 - LOGNORMAL-N - 2 PARAMETERS
        DIST(365:376) = 'LOGNORMAL-N '
        IDSST(29) = 365
        IDSEND(29) = 376
        IDSPAR(29) =  2
C
C     -- DISTRIBUTION 30 - BOUNDED NORMAL - 4 PARAMETERS
        DIST(377:391) = 'BOUNDED NORMAL '
        IDSST(30) = 377
        IDSEND(30) = 391
        IDSPAR(30) =  4
C
C     -- DISTRIBUTION 31 - TRUNCATED NORMAL - 4 PARAMETERS
        DIST(392:408) = 'TRUNCATED NORMAL '
        IDSST(31) = 392
        IDSEND(31) = 408
        IDSPAR(31) =  4
C
C     -- DISTRIBUTION 32 - BOUNDED LOGNORMAL - 4 PARAMETERS
        DIST(409:426) = 'BOUNDED LOGNORMAL '
        IDSST(32) = 409
        IDSEND(32) = 426
        IDSPAR(32) =  4
C
C     -- DISTRIBUTION 33 - TRUNCATED LOGNORMAL - 4 PARAMETERS
        DIST(427:446) = 'TRUNCATED LOGNORMAL '
        IDSST(33) = 427
        IDSEND(33) = 446
        IDSPAR(33) =  4
C
C     -- DISTRIBUTION 34 - BOUNDED LOGNORMAL-N - 4 PARAMETERS
        DIST(447:466) = 'BOUNDED LOGNORMAL-N '
        IDSST(34) = 447
        IDSEND(34) = 466
        IDSPAR(34) =  4
C
C     -- DISTRIBUTION 35 - TRUNCATED LOGNORMAL-N - 4 PARAMETERS
        DIST(467:488) = 'TRUNCATED LOGNORMAL-N '
        IDSST(35) = 467
        IDSEND(35) = 488
        IDSPAR(35) =  4
C
C     -- DISTRIBUTION 36 - GUMBEL 2 PARAMETERS
        DIST(489:495) = 'GUMBEL '
        IDSST(36) = 489
        IDSEND(36) = 495
        IDSPAR(36) =  2
C
C     -- DISTRIBUTION 37 - FRECHET 2 PARAMETERS
        DIST(496:503) = 'FRECHET '
        IDSST(37) = 496
        IDSEND(37) = 503
        IDSPAR(37) =  2
C
C
        RETURN
C
      END SUBROUTINE
C
      SUBROUTINE DISTNM_CLOSE()
C
        DEALLOCATE( IDSST, IDSEND, IDSPAR )
C
        RETURN
C
      END SUBROUTINE
C
      END MODULE
C
