#!/usr/bin/perl
#
# This utility script modifies LaTeX source files (*.tex) generated by doxygen
# for generating more optimized Reference and Developers Manuals for DAKOTA.
# It automates the modifications documented in header-ref.tex and header-dev.tex
# (which become latex-ref/refman.tex and latex-dev/refman.tex).
#
# The script contains logic to prevent multiple applications of the desired
# modifications.  This allows it to be used when the Developers/Reference files
# are in a mixed state (some modified, some unmodified).

################################
# Reference Manual: refman.tex #
################################
$texfile = "latex-ref/refman.tex";
$newtexfile = $texfile . "_";
open (INPUT,  "<$texfile")    || die "cannot open original file $texfile\n$!";
open (OUTPUT, ">$newtexfile") || die "cannot open new file $newtexfile\n$!";
print "Processing $texfile\n";

# read input file until EOF
while (<INPUT>) { # read each line of file
  if (/^\\(chapter{DAKOTA Directory Hierarchy}|input{dirs}|chapter{DAKOTA Hierarchical Index}|input\{hierarchy}|chapter{DAKOTA File Index}|input\{files}|chapter{DAKOTA Page Index}|input\{pages}|chapter{DAKOTA Directory Documentation}|input{dir_000000}|chapter{DAKOTA Page Documentation}|printindex)/) {
    print OUTPUT "%$_";
  }
  elsif (/^\\include\{(\w*Commands|Bibliography)}/) {
    s/\\include\{/\\input\{/;
    print OUTPUT;
  }
  else {
    print OUTPUT;
  }
}

# close both files
close (INPUT);
close (OUTPUT);

# Replace original file with new file
rename $newtexfile, $texfile;

#################################################
# Reference Manual: Commands/Bibliography files #
#################################################
@texfiles = (<latex-ref/*Commands.tex>, "latex-ref/Bibliography.tex");

# for each LaTeX Commands file in latex-ref, perform modifications
foreach $texfile (@texfiles) {

  open (INPUT, "$texfile") || die "cannot open original file $texfile\n$!";
  $_ = <INPUT>;
  if ( /\\chapter/ ) {
    print "$texfile already processed\n";
    close (INPUT);
  }
  else {
    print "Processing $texfile\n";
    seek INPUT, 0, 0; # rewind to beginning
    $newtexfile = $texfile . "_";
    open (OUTPUT, ">$newtexfile") || die "cannot open new file $newtexfile\n$!";

    # read input file until EOF
    while (<INPUT>) { # read each line of file

      # Promote sectioning macros up one level:
      # \section       -> \chapter
      # \subsection    -> \section
      # \subsubsection -> \subsection

      s/\\section/\\chapter/go;
      s/\\subsection/\\section/go;
      s/\\subsubsection/\\subsection/go;

      # Change table declarations
      s/table\}\[h\]/table}[htp!]/g;

      print OUTPUT;
    }

    # close both files
    close (INPUT);
    close (OUTPUT);

    # Replace original file with new file
    rename $newtexfile, $texfile;
  }
}

#################################
# Developers Manual: refman.tex #
#################################
$texfile = "latex-dev/refman.tex";
$newtexfile = $texfile . "_";
open (INPUT,  "<$texfile")    || die "cannot open original file $texfile\n$!";
open (OUTPUT, ">$newtexfile") || die "cannot open new file $newtexfile\n$!";
print "Processing $texfile\n";

# read input file until EOF
while (<INPUT>) { # read each line of file
  if (/^\\(chapter{DAKOTA Page Documentation}|include{todo})/) {
    print OUTPUT "%$_";
  }
  elsif (/^\\include\{(DakLibrary|FnEvals|RecommPract|SoftwareTools|SpecChange)}/) {
    s/\\include\{/\\input\{/;
    print OUTPUT;
  }
  else {
    print OUTPUT;
  }
}

# close both files
close (INPUT);
close (OUTPUT);

# Replace original file with new file
rename $newtexfile, $texfile;

######################################
# Developers Manual: extra dox files #
######################################
@texfiles = ("latex-dev/DakLibrary.tex",  "latex-dev/FnEvals.tex",
             "latex-dev/RecommPract.tex", "latex-dev/SpecChange.tex",
	     "latex-dev/SoftwareTools.tex");

# for each LaTeX special topics file in latex-dev, perform modifications
foreach $texfile (@texfiles) {

  open (INPUT, "$texfile") || die "cannot open original file $texfile\n$!";
  $_ = <INPUT>;
  if ( /\\chapter/ ) {
    print "$texfile already processed\n";
    close (INPUT);
  }
  else {
    print "Processing $texfile\n";
    seek INPUT, 0, 0; # rewind to beginning
    $newtexfile = $texfile . "_";
    open (OUTPUT, ">$newtexfile") || die "cannot open new file $newtexfile\n$!";

    # read input file until EOF
    while (<INPUT>) { # read each line of file

      # Promote sectioning macros up one level:
      # \section       -> \chapter
      # \subsection    -> \section
      # \subsubsection -> \subsection

      s/\\section/\\chapter/go;
      s/\\subsection/\\section/go;
      s/\\subsubsection/\\subsection/go;

      print OUTPUT;
    }

    # close both files
    close (INPUT);
    close (OUTPUT);

    # Replace original file with new file
    rename $newtexfile, $texfile;
  }
}

print "LaTeX modification Script Complete.\n";
