#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=`grep -c processor /proc/cpuinfo`;

#version of metis
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/metis-//g'`
echo $version

#Some cleanup
rm -rf install metis-$version

#Create install directories
mkdir install

#Untar 
tar -zxvf  metis-$version.tar.gz

#Move metis into install directory
mv metis-$version/* install
rm -rf metis-$version

#Apply patch
cd install 
patch Makefile.in ../Makefile.in.patch

#Compile metis
make  -j $NUMCPUS

#Patch proto.h
patch Lib/proto.h ../proto.h.patch

