#!/bin/bash
#This script will run anything popping up in the current directory, using the Cielo 
#software. 

#Get paths correctly setup
source ~/.bash_profile

#Ok, we are being launched by the cron job. We are going through all the files, detecting which 
#ones have a .queue attached to them. For those files, check whether a .errlog and .outlog are already present.
#If they are, skip this file, it is already being run. For the other ones, source the queue file.

numberoffiles=`ls *.queue 2> /dev/null | wc -l`

if [[ $numberoffiles != 0 ]]
then
	for i  in *.queue
	do
		name=`echo $i | sed 's/.queue//'`
		if [ ! -e $name.outlog ]
		then
			#Launch "name" job
			source $name.queue
		fi
	done
fi
