/*
================================================================================
    PROJECT:

        John Eddy's Genetic Algorithms (JEGA) Managed Front End

    CONTENTS:

        Implementation of class ManagedUtils.

    NOTES:

        See notes of ManagedUtils.hpp.

    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        See the LICENSE file in the top level JEGA directory.

    VERSION:

        1.0.0

    CHANGES:

        Wed Feb 08 16:35:10 2006 - Original Version (JE)

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the implementation of the ManagedUtils class.
 */




/*
================================================================================
Includes
================================================================================
*/
#include <stdafx.h>
#include <ManagedUtils.hpp>

#pragma unmanaged
#include <utilities/include/EDDY_DebugScope.hpp>
#pragma managed




/*
================================================================================
Namespace Using Directives
================================================================================
*/
using namespace std;
using namespace System::Runtime::InteropServices;








/*
================================================================================
Begin Namespace
================================================================================
*/
namespace JEGA {
    namespace FrontEnd {
        namespace Managed {





/*
================================================================================
Static Member Data Definitions
================================================================================
*/








/*
================================================================================
Mutators
================================================================================
*/








/*
================================================================================
Accessors
================================================================================
*/








/*
================================================================================
Public Methods
================================================================================
*/

System::String MOH
ManagedUtils::ToSysString(
    const char* cstr
    )
{
    EDDY_FUNC_DEBUGSCOPE
    return MANAGED_GCNEW System::String(cstr);
}

System::String MOH
ManagedUtils::ToSysString(
    const string& stdStr
    )
{
    EDDY_FUNC_DEBUGSCOPE
    return ToSysString(stdStr.c_str());
}








/*
================================================================================
Subclass Visible Methods
================================================================================
*/








/*
================================================================================
Subclass Overridable Methods
================================================================================
*/








/*
================================================================================
Private Methods
================================================================================
*/








/*
================================================================================
Structors
================================================================================
*/




std::vector<double>
ToDoubleVector(
    DoubleVector MOH ar
    )
{
    EDDY_FUNC_DEBUGSCOPE
    std::vector<double> ret;

    MANAGED_IENUMERATOR(System::Double) MOH oe = ar->GetEnumerator();
    while(oe->MoveNext())
    {
        // This cannot be reserve and push_back because of problems
        // converting unboxed value types to native reference types.
        double tpb = System::Convert::ToDouble(oe->Current);
        ret.push_back(tpb);
    }

    return ret;
}

std::vector<int>
ToIntVector(
    IntVector MOH ar
    )
{
    EDDY_FUNC_DEBUGSCOPE
    std::vector<int> ret;

    MANAGED_IENUMERATOR(System::Int32) MOH oe = ar->GetEnumerator();
    while(oe->MoveNext())
    {
        // This cannot be reserve and push_back because of problems
        // converting unboxed value types to native reference types.
        int tpb = System::Convert::ToInt32(oe->Current);
        ret.push_back(tpb);
    }

    return ret;
}

std::string
ToStdStr(
    System::String MOH sysStr
    )
{
    const char* chrs =
        (const char*)(Marshal::StringToHGlobalAnsi(sysStr)).ToPointer();
    std::string ret(chrs);
    Marshal::FreeHGlobal(System::IntPtr((void*)chrs));
    return ret;
}



/*
================================================================================
End Namespace
================================================================================
*/
        } // namespace Managed
    } // namespace FrontEnd
} // namespace JEGA


