#!/usr/bin/perl
#

##
## BEGIN COPY HERE
##
use Cwd;

#
# See if the first argument is '-I' which specifies an include path
# for the TestLib module
#
$ctr=0;
if ($ARGV[0] eq "-I") {
   unshift @INC, $ARGV[1];
   $ENV{'PATH'} = $ENV{'PATH'} . ":.:" . $ARGV[1];
   $ctr = 2;
   }
#
# See if the TESTLIBDIR environmental variable is set, which provides
# an include path for the TestLib module
#
$pwd = `pwd`;
chomp($pwd);
if ($ENV{TESTLIBDIR} ne "") {
   $tmp = $ENV{TESTLIBDIR};
   @words = split /[ ]+/, $tmp, $#tmp;
   foreach $word (@words) {
     unshift @INC, $word;
     }
   }
require TestLib;
##
## END COPY HERE
##

#
# Statistics collected by the analyzeData call-back routine
#
$final_seed="ERROR";
$final_status="ERROR";
$final_value="ERROR";
$final_cvalue="ERROR";
$final_rtime="ERROR";
$final_ttime="ERROR";
$final_neval="ERROR";
$final_modelstatus="ERROR";
$final_solverstatus="ERROR";
@final_point=();

@trial_seed=();
@trial_status=();
@trial_value=();
@trial_cvalue=();
@trial_rtime=();
@trial_ttime=();
@trial_neval=();
@trial_modelstatus=();
@trial_solverstatus=();
@trial_point=();


#
# Update the list of data
#
sub update_stats {
  push @trial_seed, $final_seed;
  push @trial_status, $final_status;
  push @trial_value, $final_value;
  push @trial_cvalue, $final_cvalue;
  push @trial_rtime, $final_rtime;
  push @trial_ttime, $final_ttime;
  push @trial_neval, $final_neval;
  push @trial_modelstatus, $final_modelstatus;
  push @trial_solverstatus, $final_solverstatus;
  push @trial_point, $final_point;
}


#
# A callback routine that is used to analyze an output file generated by
# PICO.
#
sub analyzeData {
    my $filename = @_[1];
    open (INPUT, $filename) || die "cannot open file $filename!";
    while ($line = <INPUT>) {
      chomp($line);
      @word = split /[ \t]+/, $line, $#line;
      if ($#word > 0) {
         if ($word[0] eq "") {
            shift @word;
         }
         elsif ($word[0] eq "Final-Value:") {
            $final_value = eval($word[1]);
	}
         elsif ($word[0] eq "Final-Stats:") {
            $final_neval = eval($word[2]);
            $final_cvalue = eval($word[4]);
         }
         elsif ($word[0] eq "Termination:") {
            $final_status = $word[1];
         }
         elsif ($word[0] eq "Solver-Time:") {
            $final_rtime = eval($word[1]);
         }
         elsif ($word[0] eq "Total-Time:") {
            $final_ttime = eval($word[1]);
         }
         elsif ($word[0] eq "Seed:") {
            $final_seed = eval($word[1]);
         }
         elsif ($word[0] eq "ModelStatus:") {
            $final_modelstatus = $word[1];
         }
         elsif ($word[0] eq "SolverStatus:") {
            $final_solverstatus = $word[1];
         }
         elsif ($word[0] eq "Final-Point:") {
            shift @word;
	    @final_point = @word;
         }
      }
    }
  if ($final_value eq "ERROR") {
     @_[3]  = "Fail";
     }
  close(INPUT);
  update_stats();
}

#
# Default description value
#
$description="  <Description>ERROR</Description>\n";

#
# A callback that is used to print measurement information
#
sub printMeasurements {
     print $description;
     $i = 0;
     while ($i <= $#trial_status) {
       print "  <Trial id=\"$i\" seed=\"$trial_seed[$i]\">\n";

       print "     <Value name=\"Value\" type=\"numeric/double\">$trial_value[$i]</Value>\n";
       print "     <Value name=\"ConstraintViolation\" type=\"numeric/double\">$trial_cvalue[$i]</Value>\n";

       print "     <Value name=\"NumEvaluations\" type=\"numeric/int\">$trial_neval[$i]</Value>\n";
       print "     <Value name=\"TerminationStatus\">$trial_status[$i]</Value>\n";
       print "     <Value name=\"ModelStatus\">$trial_modelstatus[$i]</Value>\n";
       print "     <Value name=\"SolverStatus\">$trial_solverstatus[$i]</Value>\n";
       print "     <Value name=\"NormalizedValue\" type=\"numeric/double\">";
       if (($trial_value[$i] eq "ERROR") || ($solnvalue eq "unknown")) {
          print "ERROR";
       } else {
          print ($trial_value[$i]-$solnvalue+1.0);
       }
       print "</Value>\n";
  
       print "     <Value name=\"SolverTime\" type=\"numeric/double\">";
       if ($trial_rtime[$i] eq "ERROR") {
          print "ERROR";
       } else {
          print $trial_rtime[$i];
       }
       print "</Value>\n";
  
       print "     <Value name=\"TotalTime\" type=\"numeric/double\">";
       if ($trial_ttime[$i] eq "ERROR") {
          print "ERROR";
       } else {
          print $trial_ttime[$i];
       }
       print "</Value>\n";
  
       print "  </Trial>\n";
       $i = $i + 1;
     }
}


##
## MAIN ROUTINE
##
if (! @ARGV) {
   print "\n";
   print "exp.coliny.pl - Coliny experiment driver\n";
   print "\n";
   print "usage:\n";
   print "\n";
   print "   exp.coliny.pl [options] <expname> <testname> <factor-id> <factor-value> [...]\n";
   print "\n";
   print "options:\n";
   print "\n";
   print "   --debug\t\tPrint debugging information.\n";
   print "\n";
   print "notes:\n";
   print "\n";
   print "   This script is launched by 'runexp' to execute and process a\n";
   print "   single test from an experiment file.  The output of this test\n";
   print "   is stored in the file <expname>-<testname>.out, which can be\n";
   print "   reviewed after the test is performed.  This script generates an\n";
   print "   XML summary that is included in the <expname>.results.xml file\n";
   print "   by 'runexp'.\n";
   print "\n";
   print "   This script is not intended for interactive use.  Consequently,\n";
   print "   the processing of the command-line options is somewhat fragile.\n";
   print "   For example, it depends on the order in which the options are\n";
   print "   processed in this script!\n";
   print "\n";
   print "   This script assumes that the first factor is the test information,\n";
   print "   and the remaining factors specify command-line options.\n";
   exit;
}
#
# Process command line arguments
#
$testoptions = "";
if ($ARGV[$ctr] eq "--debug") {
   $ctr += 1;
   $debug = 1;
}
$description = TestLib::generate_description($ctr,@ARGV);
$expname = $ARGV[$ctr];
$ctr +=1;
$testname = $ARGV[$ctr];
$ctr +=1;
$ntrials = $ARGV[$ctr];
$ctr+=1;

$factorstart=$ctr;
$factorname = $ARGV[$ctr];
$ctr+=1;
$factors = $ARGV[$ctr];
$ctr+=1;
$testoptions .= $ARGV[$ctr] . " ";
$ctr+=1;
while ($ctr < $#ARGV) {
  $factorname = $ARGV[$ctr];
  $ctr+=1;
  $factors .= " " . $ARGV[$ctr];
  $ctr+=1;
  $testoptions .= $ARGV[$ctr] . " ";
  $ctr+=1;
}
if ($debug == 1) {
   print "options: $testoptions\n";
}
#
# Process experiment tag/value pairs
#
# This is a convention that is not explicitly supported by the 
# UTILIB testing 'runexp' utility, but this is a convenient way for
# structuring experiment testing.
#
$solnvalue = "unknown";
$tolerance = 1e-12;
$files = "";
%testparams = ();
$auxoptions = TestLib::process_testoptions($testoptions, \%testparams);
#print "AUXOPTIONS $auxoptions\n";
if (defined($testparams{"_optimum"})) {
   $solnvalue = $testparams{"_optimum"};
} elsif (defined($testparams{"_value"})) {
   $solnvalue = $testparams{"_value"};
}
#
# Find the solvers used by coliny.
#
foreach $word (split(/ /,$auxoptions)) {
  if (substr($word,0,7) eq "solver=") {
     $solver = substr($word,7,length($word)-7);
     break;
     }
}
$colinyoptions = "";
@solvers = split(/-/,$solver);
foreach $lsolver (@solvers) {
  #print "$lsolver\n";
  eval("\$" . $lsolver . "options = \"\"");
}
#
# Process factors to associate factors with specific solvers (for hybrids)
#
$ctr=$factorstart;
while ($ctr < $#ARGV) {
  $factorname = $ARGV[$ctr];
  $ctr+=1;
  $factors .= " " . $ARGV[$ctr];
  $ctr+=1;
  #$testoptions .= $ARGV[$ctr] . " ";
  $flag=0;
  foreach $lsolver (@solvers) {
    if ( (substr($factorname,0,length($lsolver)+1) eq $lsolver . "_") ||
         (substr($factorname,0,length($lsolver)+1) eq $lsolver . "-")) {
       eval("\$" . $lsolver . "options .= \"" . $ARGV[$ctr] . " \"");
       $flag=1;
       break; 
       }
    }
  if ($flag == 0) {
     $colinyoptions .= $ARGV[$ctr] . " ";
     }
  $ctr+=1;
}
if ($debug == 1) {
   foreach $lsolver (@solvers) {
     eval("print \"HERE " . $lsolver . " \$" . $lsolver . "options\n\";");
   }
   print "HERE $colinyoptions\n";
   }

foreach $word (TestLib::get_tokens($testparams{"_data"})) {
  $files = $files . $word . " ";
}
if ($debug == 1) {
   print "solver:    $solver\n";
   print "exp:       $expname\n";
   print "value:     $solnvalue\n";
   print "tolerance: $tolerance\n";
   print "data:      $files\n";
}
#
# Setup AMPL command line and ampl driver model
#
$cmdline = "touch %s; ampl ${expname}-${testname}.mod > %s";
open(OUTPUT,">${expname}-${testname}.mod") || die "Cannot open AMPL driver model file: ${expname}-${testname}.mod\n";
@words = TestLib::get_tokens($files);
while (@words) {
  local $tmp = shift @words;
  print OUTPUT "include $tmp ;\n";
  }
$dir = getcwd;
@dirwords = split(/\//,$dir);
if ($dirwords[1] eq "cygdrive") { $solverdir = `cygpath -m $dir`; }
else { $solverdir = $dir; }
chomp $solverdir;
print OUTPUT "option solver \"$solverdir/colinytest\";\n";
print OUTPUT "option coliny_options (\"solver=$solver output_header=verbose seed=\" & \$PSEUDORANDOM_SEED & \" param-file=$expname-$testname.param\");\n";
print OUTPUT "solve;\n";
close(OUTPUT);
#
# Create parmeter file
#
open(OUTPUT,">${expname}-${testname}.param") || die "Cannot open Coliny parameter file: ${expname}-${testname}.param\n";
$tmp = TestLib::process_testoptions($colinyoptions, \%testparams);
#print "TMP $tmp\n";
foreach $option (split(/ /,$tmp)) {
  @words = split(/=/,$option);
  if ($words[0] ne "solver") {
     if ($#words == 0) {
        print OUTPUT "$words[0] true\n";
     } else {
        print OUTPUT "$words[0] $words[1]\n";
     }
     }
  }
$first=1;
foreach $lsolver (@solvers) {
  if ($first == 0) {
     print OUTPUT "END-SOLVER\n";
  }
  #print "\# $lsolver\n";
  print OUTPUT "\# $lsolver\n";
  eval("\$tmp = TestLib::process_testoptions(\$" . $lsolver . "options, \\%testparams);");
  #print "TMP $tmp\n";
  foreach $option (split(/ /,$tmp)) {
    @words = split(/=/,$option);
    #print "OPTION $option\n";
    #foreach $word (@words) {
      #print "WORD: $word $#words\n";
    #}
    if ($words[0] ne "solver") {
       if ($#words == 0) {
          print OUTPUT "$words[0] true\n";
       } else {
          print OUTPUT "$words[0] $words[1]\n";
       }
       }
  }
  $first=0;
}
close(OUTPUT);
#
# DEBUGGING
#
if ($debug == 1) {
   print "CMDLINE: $cmdline\n";
}
#
# Launch the test with the TestLib driver.
#
TestLib::run_experiments(\*STDOUT, $expname, $testname, $cmdline, $ntrials, \&analyzeData, \&printMeasurements, $auxoptions, \%testparams);
