function [ru_g m]=cielodiagnostic_core_linear(m,params,inputs,analysis)
%INPUT ru_g =cielodiagnostic_core_linear(m,params,inputs,analysis)

	%check inputs
	if isempty(inputs),
		clear inputs;
	end

	%recover flag_y_s from m.y_s
	if isempty(m.y_s),
		flag_y_s= 0;
	else
		flag_y_s= 1;
	end

	%stiffness and load generation only:
	params.kflag=1; params.pflag=1;
	params.ktflag=0;

	%system matrices
	[rK_gg , rp_g , rdK_gg]=Emg(m.bgpdt,m.bgpdtb, m.est,m.lst,m.ept,m.mpt,m.geom3,params,inputs,analysis);
	
	%Reduce tangent matrix from g size to f size
	[rK_ff, rK_fs] = Reducematrixfromgtof( rK_gg, m.G_mn, flag_y_s ); 

	%Cleanup memory
	rK_gg=IMdb('drop rK_gg');
	if ~isempty(rdK_gg), rdK_gg=IMdb('drop rdK_gg');end;
	
	%Reduce load from g size to f size
	[rp_f] = Reducerightside( rp_g, m.G_mn, rK_fs, m.y_s, flag_y_s );
	
	%Cleanup memory
	[rp_g rK_fs]=IMdb('drop rp_g rK_fs');
	
	%Solve	
	[ru_f]=Solver(rK_ff,rp_f,{},params.solverstring);

	%Cleanup memory
	[rK_ff rp_f]=IMdb('drop rK_ff rp_f');
	
	%Merge back to g set
	ru_g= Mergesolvec( ru_f, m.G_mn, m.y_s ); 
	
	%Cleanup memory
	ru_f=IMdb('drop ru_f ');

end %end function
