%STARTUP - Matlab startup script
%
%   startup.m is a script run by matlab at the beginning of a session, just before 
%   handing over the prompt to the user. This delivery startup.m script has been customized here for 
%   the ISSM code. This startup script should be run by users before trying to use ISSM. The best way 
%   to do that is to put the startup file in the location where Matlab starts and established its root
%   directory.
%
%   Copyright Jet Propulsion Laboratory. 

global ISSM_DIR 
lastwarn(''); % clear the last warning to focus on the warnings of the ISSM path

%Recover ISSM_DIR 
[status,ISSM_DIR]=system('echo $ISSM_DIR');
if status~=0,
	error('issmdir error message: problem when running ''echo $ISSM_DIR'' shell command');
end
if (isempty(ISSM_DIR)) | (length(ISSM_DIR)==1),
	error('issmdir error message: ''ISSM_DIR'' environment variable is empty! You should define ISSM_DIR in your .cshrc or .bashrc!');
end
%get rid of return carriage
ISSM_DIR=ISSM_DIR(1:end-1);

%Now add all ice code paths necessary to run ice smoothly. 
%We capture the error output, so that we can warn the user to update 
%the variable ISSM_DIR in this file, in case it is not correctly setup. 

%ISSM path
addpath([ISSM_DIR '/src/m/utils/']); %loads genpath_ice
addpath([ISSM_DIR '/etc']);
addpath([ISSM_DIR '/doc']);
addpath(genpath_ice([ISSM_DIR '/src/m']));

%Suite sparse and m2html
addpath(genpath_ice([ISSM_DIR '/packages/suitesparse/install/CHOLMOD/MATLAB/']));
addpath(genpath_ice([ISSM_DIR '/packages/m2html/install']));

%last one, to pick up binaries first!
addpath([ISSM_DIR '/bin']);

%Check on any warning messages that might indicate that the paths were not correct. 
if ~isempty(lastwarn),
	disp(' ');
	disp('  Error trying to setup ''ISSM'' code paths. Try and update the ISSM_DIR variable in the startup.m file');
	disp('  ''ISSM'' will not  work at all until this is resolved');
else
	disp(' ');
	disp('  To get started with ISSM, type issmdoc at the command prompt.');
	disp(' ');
end
