function  [field,fieldispresent]=recover_input(inputs,fieldname)
%RECOVER_INPUT - recover the field of a structure
%
%   From a certain structure, recover the field that corresponds to a certain 
%   field name. For example: field=recover_input(input,'bof') where input=struct('bof',4,'baf',5)
%   will return the value 4, and 1 for fieldispresent. If 'bof' field did not exist, field would be 
%   NaN and fieldispresent would be 0.
%
%   Usage:
%      [field,fieldispresent]=recover_input(inputs,fieldname)

if  isfield(inputs,fieldname),
	field=getfield(inputs,fieldname);
	if ~isempty(field),
		fieldispresent=1;
	else
		fieldispresent=0;
	end
else
	field=NaN;
	fieldispresent=0;
end
