/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:       SingleModel
//- Description: Implementation code for the SingleModel class
//- Owner:       Mike Eldred
//- Checked by:

#include "system_defs.h"
#include "SingleModel.H"
#include "ProblemDescDB.H"

static const char rcsId[]="@(#) $Id: SingleModel.C 4682 2007-10-26 23:53:35Z mseldre $";


namespace Dakota {

// define special values for componentParallelMode
#define INTERFACE 1


SingleModel::SingleModel(ProblemDescDB& problem_db):
  Model(BaseConstructor(), problem_db),
  userDefinedInterface(problem_db.get_interface())
{ componentParallelMode = INTERFACE; }


void SingleModel::component_parallel_mode(short mode)
{
  if (mode != INTERFACE) {
    Cerr << "Error: SingleModel only supports the INTERFACE component parallel "
	 << "mode." << endl;
    abort_handler(-1);
  }
  parallelLib.parallel_configuration_iterator(modelPCIter);
  //componentParallelMode = mode;
}

} // namespace Dakota
