function displayqmu(md)
%DISPLAYQMU - display qmu computation parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays all fields related to
%   qmu computation from model md, only if requested.
%
%   Usage:
%      displayqmu(md)

disp(sprintf('      ''%s''','qmu using Dakota'));
disp(sprintf('         variables:  (arrays of each variable class)'));
fnames=fieldnames(md.variables);
for i=1:length(fnames);
    disp(sprintf('            %s    [%ix%i]    ''%s''',...
        fnames{i},size(md.variables.(fnames{i})),class(md.variables.(fnames{i}))));
end
disp(sprintf('         responses:  (arrays of each response class)'));
fnames=fieldnames(md.responses);
for i=1:length(fnames);
    disp(sprintf('            %s    [%ix%i]    ''%s''',...
        fnames{i},size(md.responses.(fnames{i})),class(md.responses.(fnames{i}))));
end
disp(sprintf('         dakotaresults: 1x%i   {dvar,rfunc,scm,pcm,srcm,prcm}',length(md.dakotaresults)));
if isempty(md.dakotain), disp(sprintf('         dakotain: N/A')); else disp(sprintf('         dakotain: not displayed (can be accessed by typing md.dakotain)'));end
if isempty(md.dakotaout), disp(sprintf('         dakotaout: N/A')); else disp(sprintf('         dakotaout: not displayed (can be accessed by typing md.dakotaout)'));end
if isempty(md.dakotadat), disp(sprintf('         dakotadat: N/A')); else disp(sprintf('         dakotadat: not displayed (can be accessed by typing md.dakotadat)'));end
disp(sprintf('         method: ''%s'' (''local reliability'' or ''sampling'')',md.method));
disp(sprintf('         seed: %g (random seed number)',md.seed));
disp(sprintf('         samples: %i (number of samples)',md.samples));
disp(sprintf('         sample_type: ''%s'' (type of sampling, ''random'' or ''lhs'')',md.sample_type));
disp(sprintf('         interval_type: ''%s'' (FD ''forward'' or ''central'')',md.interval_type));
disp(sprintf('         fd_gradient_step_size: %g (FD gradient step size, default= .001) ',md.fd_gradient_step_size));
disp(sprintf('         evaluation_concurrency: %i (evaluation concurrency level)',md.evaluation_concurrency));
disp(sprintf('         npart: %i (number of partitions for semi-descrete qmu)',md.npart));
disp(sprintf('         analysis_driver    : ''%s'' (''matlab'' or name of driver for Dakota analysis)',md.analysis_driver));
disp(sprintf('         analysis_components: ''%s'' (Matlab script file for Matlab driver)',md.analysis_components));
