function plot_results(Action,varargin)
%PLOT_RESULTS - plot results
%
%   This routine seems to be obsolete... move to Trash?
%
%   Usage:
%      plot_results(Action,varargin)

global index x y u v vel

if nargin==0,
   Action='initialize';
   series=1;
end

if nargin==1,
   if length(Action)==1,
         series=Action;
         Action='initialize';
   end
end

      

if nargin==2,
   series=varargin{1};
end

switch Action

   %---Initialize the demonstration
case 'initialize'
   LocalOpenFig(series);
case 'ToggleButton'    
         
 
   value=findobj(gcf,'Tag','Choice');
   value=popupstr(value);
   
   
      year=findobj(gcf,'Tag','Version');
   	year_value=popupstr(year);
   
  		zoom=findobj(gcf,'Tag','Zoom');
   	zoom_value=popupstr(zoom);
   
  		ser=findobj(gcf,'Tag','Series');
      series=popupstr(ser);
      series=str2num(series);
      
      diff=findobj(gcf,'Tag','Diff');
      diff_value=popupstr(diff);
      
      diff_choice=findobj(gcf,'Tag','Diff_choice');
      diff_choice=popupstr(diff_choice);
      
      range_choice=findobj(gcf,'Tag','Range_choice');
      range_choice=popupstr(range_choice);
      if strcmp(range_choice,'auto'),
         range_choice=0;
      else
         range_choice=1;
      end
      
      range=findobj(gcf,'Tag','Range');
      range=deblank(get(range,'String'));

      



      switch zoom_value,
   	case 'RONNE'
      zo=0;
   	case 'HIR'
         zo=1;
      case 'LASSITER'
         zo=2;
         case 'MIDDLE'
         zo=3;

   	end
   
   
   	switch	value
   	case 'obs_ronne'
         plot_obs_ronne(year_value,zo,series,range_choice,range);
      case 'obs_hir_vx'
         plot_obs_hir_vx(year_value,zo,series,range_choice,range);
      case 'obs_hir_vy'
         plot_obs_hir_vy(year_value,zo,series,range_choice,range);
      case 'obs_hir_vel'
         plot_obs_hir_vel(year_value,zo,series,range_choice,range);
 		case 'u'
          plot_u(year_value,zo,series,range_choice,range);
      case 'diff_u_hir'
          plot_diff_u_hir(year_value,zo,series,range_choice,range);
   	case 'v'
         plot_v(year_value,zo,series,range_choice,range);
      case 'v_prism'
         plot_v_prism(year_value,zo,series,range_choice,range);
      case 'diff_v_hir'
          plot_diff_v_hir(year_value,zo,series,range_choice,range);
   	case 'vel'
         plot_vel(year_value,zo,series,range_choice,range);
		case 'vel_prism'
         plot_vel_prism(year_value,zo,series,range_choice,range);
      case 'diff_vel_ronne'
         plot_diff_vel_ronne(year_value,zo,series,range_choice,range);
      case 'diff_vel_hir'
         plot_diff_vel_hir(year_value,zo,series,range_choice,range);
      case 'rotation_hir'
         plot_rotation_hir(year_value,zo,series,range_choice,range);
		case 'rotation_model'
         plot_rotation_model(year_value,zo,series,range_choice,range);
		case 'diff_rotation'
         plot_diff_rotation(year_value,zo,series,range_choice,range);
		case 'quiver_hir'
         plot_quiver_hir(year_value,zo,series,range_choice,range);
      case 'quiver_las'
         plot_quiver_las(year_value,zo,series,range_choice,range);
		case 'quiver_model'
         plot_quiver_model(year_value,zo,series,range_choice,range);
		case 'mesh'
         plot_mesh(year_value,zo,series,range_choice,range);
      case 'obs_LAS_vx'
         plot_obs_LAS_vx(year_value,zo,series,range_choice,range);
      case 'obs_LAS_vy'
         plot_obs_LAS_vy(year_value,zo,series,range_choice,range);
      case 'obs_LAS_vel'
         plot_obs_LAS_vel(year_value,zo,series,range_choice,range);
      case 'diff_u_LAS'
         plot_diff_u_LAS(year_value,zo,series,range_choice,range);
      case 'diff_v_LAS'
         plot_diff_v_LAS(year_value,zo,series,range_choice,range);
      case 'diff_vel_LAS'
         plot_diff_vel_LAS(year_value,zo,series,range_choice,range);
         
         





   	case 'tau1'
      	plot_tau1(year_value,zo,series,range_choice,range);
   	case 'tau2'
      	plot_tau2(year_value,zo,series,range_choice,range);
		case 'teta1'
   	   plot_teta1(year_value,zo,series,range_choice,range);
   	case 'teta2'
         plot_teta2(year_value,zo,series,range_choice,range);


      case 'thick'
         plot_thick(year_value,zo,series,range_choice,range);
		case 'thickbar'
         plot_thickbar(year_value,zo,series,range_choice,range);

   
	   otherwise
   	   plot_results('Refresh');
      end
      
      
      
case   'Refresh'
   year=findobj(gcf,'Tag','Version');
   year_value=popupstr(year);
   quantity=findobj(gcf,'Tag','Choice');
   quantity_value=popupstr(quantity);
   zoom=findobj(gcf,'Tag','Zoom');
   zoom_value=popupstr(zoom);
   ser=findobj(gcf,'Tag','Series');
   series=popupstr(ser);
   diff=findobj(gcf,'Tag','Diff');
   diff_value=popupstr(diff);
      range_choice=findobj(gcf,'Tag','Range_choice');
      range_choice=popupstr(range_choice);
      if strcmp(range_choice,'auto'),
         range_choice=0;
      else
         range_choice=1;
      end
      
      range=findobj(gcf,'Tag','Range');
      range=deblank(get(range,'String'));

  

   switch zoom_value,
   case 'RONNE'
      zo=0;
   case 'HIR'
      zo=1;
   case 'LASSITER'
      zo=2;
   case 'MIDDLE'
      zo=3;
   end

   eval(['plot_' quantity_value '(' year_value ',' num2str(zo) ',' series  ',' range_choice ',' range ' )']);

   
end







%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function LocalOpenFig(series);
StdUnit = 'point';
StdColor = get(0,'DefaultUIcontrolBackgroundColor');
PointsPerPixel = 72/get(0,'ScreenPixelsPerInch');

a = figure('Color',[0.8 0.8 0.8], ...
   'Position',[25 45 560 420], ...
   'IntegerHandle','on', ...
   'Number','off',...  
   'Name','Results',...
   'Tag','Results Visualisation');

b = axes('Parent',a, ...
   'Units',StdUnit, ...
   'Box','on', ...
   'Color',[1 1 1], ...
   'Position',PointsPerPixel*[40 45 360 330], ...
   'Units','Normalized',...
   'XColor',[0 0 0], ...
   'XGrid','off', ...
   'XTick',[],...
   'YColor',[0 0 0], ...
   'YGrid','off', ...
   'YTick',[], ...
   'ZColor',[0 0 0], ...
   'ZGrid','off', ...
   'ZTick',[]);

set(get(b,'XLabel'),'visible','off');
set(get(b,'YLabel'),'visible','off');
set(get(b,'ZLabel'),'visible','off');


b = axes('Parent',a,'Units',StdUnit,'Color',[1 1 1],'Position',...
   PointsPerPixel*[40 45 360 330],'Units','Normalized',   'Tag','ActiveAxes','Box','on','XColor',[0 0 0], ...
   'XGrid','off', ...
   'YColor',[0 0 0], ...
   'YGrid','off');
names_function(1,series);
load ../data/matlab/commondata/names.mat
eval(['load ' root directory '\data']);
aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)

u=u*yts;
v=v*yts;



%---Add the 3D plot as the default
trisurf(index,x/1e3,y/1e3,u),shading interp,view(2);
caxis([-500 100]);
colorbar
set(gca,'Tag','ActiveAxes');



b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'Position',PointsPerPixel*[425 295 100 50], ...
   'Units','Normalized',...
   'Style','frame');

b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'HorizontalAlignment','left', ...
   'Position',PointsPerPixel*[430 320 80 20], ...
   'Units','Normalized',...
   'String','Series', ...
   'Style','text');


str='';
i=1;
while   exist([root 'RONNE_w' num2str(i)],'file')==7,
   str=[str num2str(i) '|'];
      i=i+1;
end
str=str(1:length(str)-1);


b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',[1 1 1], ...
   'Style','popup', ...
   'Position',PointsPerPixel*[430 300  90 20], ...
   'Units','Normalized',...
   'String',str, ...
   'callback','plot_results(''ToggleButton'');', ...
   'Tag','Series',...
	'Value',series);




%%%%%%%%%%%%%%%%%%%%%%%%5555
b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'Position',PointsPerPixel*[425 245 100 50], ...
   'Units','Normalized',...
   'Style','frame');


b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'HorizontalAlignment','left', ...
   'Position',PointsPerPixel*[430 270 80 20], ...
   'Units','Normalized',...
   'String','Version', ...
   'Style','text');



str='';
i=1;
names_function(1,series);
load ../data/matlab/commondata/names.mat
while   exist_by_names([root directory '\' results '_results.mat']),
   str=[str num2str(i) '|'];
   i=i+1;
   names_function(i,series);
   load ../data/matlab/commondata/names.mat
end
str=str(1:length(str)-1);

b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',[1 1 1], ...
   'Style','popup', ...
   'Position',PointsPerPixel*[430 250  90 20], ...
   'Units','Normalized',...
   'String',str, ...
   'callback','plot_results(''ToggleButton'');', ...
   'Tag','Version');

%%%%%%%%%%%%%%%%%%%55


b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'Position',PointsPerPixel*[425 195 100 50], ...
   'Units','Normalized',...
   'Style','frame');

b = uicontrol('Parent',a, ...
   'Unit',StdUnit,'BackgroundColor',StdColor, ...
   'HorizontalAlignment','left', ...
   'Position',PointsPerPixel*[430 220 80 20], ...
   'Units','Normalized',...
   'String','Quantity to view', ...
   'Style','text');



b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',[1 1 1], ...
   'Style','popup', ...
   'Position',PointsPerPixel*[430 200  90 20], ...
   'Units','Normalized',...
   'String','u|v|v_prism|vel|vel_prism|obs_hir_vx|obs_hir_vy|obs_hir_vel|diff_u_hir|diff_v_hir|diff_vel_hir|obs_ronne|diff_vel_ronne|obs_LAS_vx|obs_LAS_vy|obs_LAS_vel|diff_u_LAS|diff_v_LAS|diff_vel_LAS|rotation_model|rotation_hir|diff_rotation|quiver_hir|quiver_las|quiver_model|tau1|tau2|teta1|teta2|thick|thickbar|mesh', ...
   'callback','plot_results(''ToggleButton'');', ...
   'Tag','Choice');




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'Position',PointsPerPixel*[425 145 100 50], ...
   'Units','Normalized',...
   'Style','frame');

b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'HorizontalAlignment','left', ...
   'Position',PointsPerPixel*[430 170 80 20], ...
   'Units','Normalized',...
   'String','Zoom', ...
   'Style','text');



b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',[1 1 1], ...
   'Style','popup', ...
   'Position',PointsPerPixel*[430 150  90 20], ...
   'Units','Normalized',...
   'String','RONNE|HIR|LASSITER|MIDDLE', ...
   'callback','plot_results(''ToggleButton'');', ...
   'Tag','Zoom');



set(a,'visible','on','HandleVisibility','callback');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'Position',PointsPerPixel*[425 115 50 30], ...
   'Units','Normalized',...
   'Style','frame');


b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'HorizontalAlignment','left', ...
   'Position',PointsPerPixel*[430 130 40 10], ...
   'Units','Normalized',...
   'String','Diff Version', ...
   'Style','text');



str='';
i=1;
names_function(1,series);
load ../data/matlab/commondata/names.mat
while   exist_by_names([root directory '\' results '_results.mat']),
   str=[str num2str(i) '|'];
   i=i+1;
   names_function(i,series);
   load ../data/matlab/commondata/names.mat
end
str=str(1:length(str)-1);

b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',[1 1 1], ...
   'Style','popup', ...
   'Position',PointsPerPixel*[430 120  40 10], ...
   'Units','Normalized',...
   'String',str, ...
   'callback','plot_results(''ToggleButton'');', ...
   'Tag','Diff');




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'Position',PointsPerPixel*[475 115 50 30], ...
   'Units','Normalized',...
   'Style','frame');

b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'HorizontalAlignment','left', ...
   'Position',PointsPerPixel*[480 130 40 10], ...
   'Units','Normalized',...
   'String','Diff mesh', ...
   'Style','text');



b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',[1 1 1], ...
   'Style','popup', ...
   'Position',PointsPerPixel*[480 120  40 10], ...
   'Units','Normalized',...
   'String','Version|Diff_version', ...
   'callback','plot_results(''ToggleButton'');', ...
   'Tag','Mesh_choice');



set(a,'visible','on','HandleVisibility','callback');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'Position',PointsPerPixel*[425 85 50 30], ...
   'Units','Normalized',...
   'Style','frame');


b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'HorizontalAlignment','left', ...
   'Position',PointsPerPixel*[430 100 40 10], ...
   'Units','Normalized',...
   'String','Plot differentials', ...
   'Style','text');



b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',[1 1 1], ...
   'Style','popup', ...
   'Position',PointsPerPixel*[430 90  40 10], ...
   'Units','Normalized',...
   'String','no|yes', ...
   'callback','plot_results(''ToggleButton'');', ...
   'Tag','Diff_choice');



set(a,'visible','on','HandleVisibility','callback');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'Position',PointsPerPixel*[475 85 50 30], ...
   'Units','Normalized',...
   'Style','frame');

b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'HorizontalAlignment','left', ...
   'Position',PointsPerPixel*[485 105 30 5], ...
   'Units','Normalized',...
   'String','Color Range', ...
   'Style','text');

b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',[1 1 1], ...
   'Position',PointsPerPixel*[480 95 40 10], ...
   'Units','Normalized',...
   'String','[  ,  ]',...
   'callback','plot_results(''ToggleButton'');', ...
   'Style','edit',...
   'Tag','Range');

       
b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',[1 1 1], ...
   'Style','popup', ...
   'Position',PointsPerPixel*[480 90 40 5], ...
   'Units','Normalized',...
   'String','auto|manual', ...
   'callback','plot_results(''ToggleButton'');', ...
   'Tag','Range_choice');



set(a,'visible','on','HandleVisibility','callback');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'Position',PointsPerPixel*[475 55 50 30], ...
   'Units','Normalized',...
   'Style','frame');

b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',StdColor, ...
   'HorizontalAlignment','left', ...
   'Position',PointsPerPixel*[485 70 30 10], ...
   'Units','Normalized',...
   'String','Quiver sparsity', ...
   'Style','text');

b = uicontrol('Parent',a, ...
   'Unit',StdUnit, ...
   'BackgroundColor',[1 1 1], ...
   'Position',PointsPerPixel*[480 60 40 10], ...
   'Units','Normalized',...
   'String','3',...
   'callback','plot_results(''ToggleButton'');', ...
   'Style','edit',...
   'Tag','Quiver_Sparsity');

       
set(a,'visible','on','HandleVisibility','callback');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function plot_obs_ronne(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
if exist_by_names([root directory '\' maillage '_observations_Ian.mat']),
   eval(['load ' root directory '/' maillage '_observations_Ian'])
   v_input=sqrt(u_RONNE.^2+v_RONNE.^2)*yts;
end



trisurf(index,x/1e3,y/1e3,v_input),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Observed velocity magnitude (m.a^(-1)). BAS data.'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);
colormap(jet)
caxis([0 1500]);
colorbar
set(gca,'Tag','ActiveAxes')
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function plot_obs_hir_vx(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)


trisurf(index,x/1e3,y/1e3,u_HIR),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Observed velocity Vx (m.a^(-1)) around HIR. From RSAT1'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)


zoom_choice(zo);
colormap(jet)
caxis([-500 100]);
colorbar
set(gca,'Tag','ActiveAxes')
end






%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function plot_obs_hir_vy(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)

trisurf(index,x/1e3,y/1e3,v_HIR),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Observed velocity Vy (m.a^(-1)) around HIR. From RSAT1'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);
colormap(jet)
caxis([0 1500]);
colorbar
set(gca,'Tag','ActiveAxes')
end






%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function plot_obs_hir_vel(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)

vel_HIR=sqrt(u_HIR.^2+v_HIR.^2);

trisurf(index,x/1e3,y/1e3,vel_HIR),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Observed velocity magnitude (m.a^(-1)) around HIR. From RSAT1'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);

colormap(jet)
caxis([0 1500]);
colorbar
set(gca,'Tag','ActiveAxes')
end






%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
function plot_u(num,zo,series,range_choice,range);
diff_choice=findobj(gcf,'Tag','Diff_choice');
diff_choice=popupstr(diff_choice);
if strcmp(diff_choice,'no')==1,


names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
u=u*yts;
v=v*yts;
trisurf(index,x/1e3,y/1e3,u),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Computed Vx (m.a^(-1)) around HIR.'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)


zoom_choice(zo);
colormap(jet)
if range_choice==0,
   caxis([-500 500]);
else
   eval(['caxis(' range ');']);
end

colorbar
set(gca,'Tag','ActiveAxes')
end

else
      diff=findobj(gcf,'Tag','Diff');
      diff_value=popupstr(diff);
      
      mesh=findobj(gcf,'Tag','Mesh_choice');
      mesh=popupstr(mesh)
      if strcmp(mesh,'Version')==1,
         mesh=1;
      else
         mesh=0;
      end
      
      

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)
vel1=u*yts;

x1=x;
y1=y;
index1=index;
end
names_function(diff_value,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)
vel2=u*yts;
x2=x;
y2=y;
index2=index;
end

if mesh==1,
   vel2=griddata(x2,y2,vel2,x1,y1);
   trisurf(index1,x1/1e3,y1/1e3,vel1-vel2),shading interp,view(2);
   title(texlabel(['Difference vx model #' num2str(num) '- vx model #' num2str(diff_value) ' on mesh ' num2str(num)]),'fontname','arial','fontsize',18);
   
else
   vel1=griddata(x1,y1,vel1,x2,y2);
   trisurf(index2,x2/1e3,y2/1e3,vel1-vel2),shading interp,view(2);
   title(texlabel(['Difference vx model #' num2str(num) '- vx model #' num2str(diff_value) ' on mesh ' num2str(diff_value)]),'fontname','arial','fontsize',18);
end

if range_choice==0,
else
   eval(['caxis(' range ');']);
end


colorbar;
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);
set(gca,'Tag','ActiveAxes')





end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
function plot_diff_u_hir(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)

u=u*yts;

trisurf(index,x/1e3,y/1e3,u-u_HIR),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Vx-Vxobs (m.a^(-1)) around HIR.'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);
colormap(jet)
%caxis([-200 200]);
colorbar
set(gca,'Tag','ActiveAxes')
end




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
function plot_v(num,zo,series,range_choice,range);
diff_choice=findobj(gcf,'Tag','Diff_choice');
diff_choice=popupstr(diff_choice);
if strcmp(diff_choice,'no')==1,


names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);
if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
u=u*yts;
v=v*yts;
trisurf(index,x/1e3,y/1e3,v),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Computed Vy (m.a^(-1)) around HIR.'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);

colormap(jet)
if range_choice==0,
caxis([0 1500]);
else
   eval(['caxis(' range ');']);
end


colorbar
set(gca,'Tag','ActiveAxes')
end

else
   diff=findobj(gcf,'Tag','Diff');
   diff_value=popupstr(diff);
    
      mesh=findobj(gcf,'Tag','Mesh_choice');
      mesh=popupstr(mesh)
      if strcmp(mesh,'Version')==1,
         mesh=1;
      else
         mesh=0;
      end
      

      

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)
vel1=v*yts;

x1=x;
y1=y;
index1=index;
end
names_function(diff_value,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data

exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)
vel2=v*yts;
x2=x;
y2=y;
index2=index;
end

if mesh==1,
   vel2=griddata(x2,y2,vel2,x1,y1);
   trisurf(index1,x1/1e3,y1/1e3,vel1-vel2),shading interp,view(2);
   title(texlabel(['Difference vy model #' num2str(num) '- vx model #' num2str(diff_value) ' on mesh ' num2str(num)]),'fontname','arial','fontsize',18);
   
else
   vel1=griddata(x1,y1,vel1,x2,y2);
   trisurf(index2,x2/1e3,y2/1e3,vel1-vel2),shading interp,view(2);
   title(texlabel(['Difference vy model #' num2str(num) '- vx model #' num2str(diff_value) ' on mesh ' num2str(diff_value)]),'fontname','arial','fontsize',18);
end

if range_choice==0,
else
   eval(['caxis(' range ');']);
end


colorbar;
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);
set(gca,'Tag','ActiveAxes')






end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
function plot_v_prism(num,zo,series,range_choice,range);
names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);
if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
v=v*yts;

trisurf(index,x/1e3,y/1e3,v),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Computed velocity magnitude (m.a^(-1)).'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)
zoom_choice(zo);
cycle=100;
caxis([0 1600]);
colormap(prism(6*cycle))
colorbar
set(gca,'Tag','ActiveAxes')
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function plot_diff_v_hir(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)

v=v*yts;

trisurf(index,x/1e3,y/1e3,v-v_HIR),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Vy-Vyobs (m.a^(-1)) around HIR.'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);

colormap(jet)
caxis([-500 500]);
colorbar
set(gca,'Tag','ActiveAxes')
end




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
function plot_vel(num,zo,series,range_choice,range);

diff_choice=findobj(gcf,'Tag','Diff_choice');
diff_choice=popupstr(diff_choice);
if strcmp(diff_choice,'no')==1,

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);
if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
u=u*yts;
v=v*yts;
vel=sqrt(u.^2+v.^2);
trisurf(index,x/1e3,y/1e3,vel),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Computed velocity magnitude (m.a^(-1)).'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)
zoom_choice(zo);
cycle=30;

if range_choice==0,
   caxis([0 1500]);

else
   eval(['caxis(' range ');']);
end

colormap(jet)
colorbar
set(gca,'Tag','ActiveAxes')

end


else

      diff=findobj(gcf,'Tag','Diff');
      diff_value=popupstr(diff);
      
       
      mesh=findobj(gcf,'Tag','Mesh_choice');
      mesh=popupstr(mesh)
      if strcmp(mesh,'Version')==1,
         mesh=1;
      else
         mesh=0;
      end
      

      

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)
vel1=sqrt(u.^2+v.^2)*yts;

x1=x;
y1=y;
index1=index;
end
names_function(diff_value,series)
load ../data/matlab/commondata/names.mat

load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)
vel2=sqrt(u.^2+v.^2)*yts;
x2=x;
y2=y;
index2=index;
end


if mesh==1,
   vel2=griddata(x2,y2,vel2,x1,y1);
   trisurf(index1,x1/1e3,y1/1e3,vel1-vel2),shading interp,view(2);
   title(texlabel(['Difference vel model #' num2str(num) '- vx model #' num2str(diff_value) ' on mesh ' num2str(num)]),'fontname','arial','fontsize',18);
   
else
   vel1=griddata(x1,y1,vel1,x2,y2);
   trisurf(index2,x2/1e3,y2/1e3,vel1-vel2),shading interp,view(2);
   title(texlabel(['Difference vel model #' num2str(num) '- vx model #' num2str(diff_value) ' on mesh ' num2str(diff_value)]),'fontname','arial','fontsize',18);
end


if range_choice==0,
else
   eval(['caxis(' range ');']);
end

colorbar;
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);
set(gca,'Tag','ActiveAxes')






   
   
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
function plot_vel_prism(num,zo,series,range_choice,range);
names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);
if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
u=u*yts;
v=v*yts;
vel=sqrt(u.^2+v.^2);

trisurf(index,x/1e3,y/1e3,vel),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Computed velocity magnitude (m.a^(-1)).'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)
zoom_choice(zo);
cycle=32;
caxis([0 1600]);
colormap(prism(6*cycle))
colorbar
set(gca,'Tag','ActiveAxes')
end




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
function plot_diff_vel_hir(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)

v=v*yts;
u=u*yts;
vel=sqrt(u.^2+v.^2);
vel_HIR=sqrt(u_HIR.^2+v_HIR.^2);

xmin=-1.09*10^6;
xmax=-960000;
ymin=8.1*10^5;
ymax=9.4*10^5;
diff=vel-vel_HIR;
diff2=abs(vel-vel_HIR);
pos=find(diff2<=50);
diff(pos)=NaN;
trisurf(index,x/1e3,y/1e3,diff),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('V-Vobs (m.a^(-1)) around HIR.'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);
colormap(jet)
caxis([-500 500]);
colorbar
set(gca,'Tag','ActiveAxes')
end




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
function plot_diff_vel_ronne(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)

if exist_by_names([root directory '\' maillage '_observations_Ian.mat']),
   eval(['load ' root directory '/' maillage '_observations_Ian'])
   v_input=sqrt(u_RONNE.^2+v_RONNE.^2)*yts;
end


v=v*yts;
u=u*yts;
vel=sqrt(u.^2+v.^2);

trisurf(index,x/1e3,y/1e3,vel-v_input),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('V-Vobs (m.a^(-1)).'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);

colormap(jet)
caxis([-500 500]);
colorbar
set(gca,'Tag','ActiveAxes')
end




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
function plot_obs_LAS_vx(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations_LAS'];
eval(aa)


trisurf(index,x/1e3,y/1e3,u_LAS),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Observed vx (m.a^(-1)) around LAS. From RSAT1'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);

colormap(jet)
%caxis([0 1500]);
colorbar
set(gca,'Tag','ActiveAxes')
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
function plot_obs_LAS_vy(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations_LAS'];
eval(aa)


trisurf(index,x/1e3,y/1e3,v_LAS),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Observed vy around LASSITER (m.a^(-1)) around LAS. From RSAT1'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);

colormap(jet)
%caxis([0 1500]);
colorbar
set(gca,'Tag','ActiveAxes')
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
function plot_obs_LAS_vel(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations_LAS'];
eval(aa)
vel_LAS=sqrt(u_LAS.^2+v_LAS.^2);

trisurf(index,x/1e3,y/1e3,vel_LAS),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Observed vel_LAS (m.a^(-1)) around LAS. From RSAT1'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);

colormap(jet)
%caxis([0 1500]);
colorbar
set(gca,'Tag','ActiveAxes')
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
function plot_diff_u_LAS(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations_LAS'];
eval(aa)

u=u*yts;
pos=find(u_LAS==0);
u_LAS(pos)=NaN;
xmin=-1.09*10^6;
xmax=-960000;
ymin=8.1*10^5;
ymax=9.4*10^5;
diff=u-u_LAS;
trisurf(index,x/1e3,y/1e3,diff),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('u-u_LAS (m.a^(-1)) around LASSITER.'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);
colormap(jet)
caxis([-500 500]);
colorbar
set(gca,'Tag','ActiveAxes')
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
function plot_diff_v_LAS(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations_LAS'];
eval(aa)

v=v*yts;
pos=find(v_LAS==0);
v_LAS(pos)=NaN;
xmin=-1.09*10^6;
xmax=-960000;
ymin=8.1*10^5;
ymax=9.4*10^5;
diff=v-v_LAS;
trisurf(index,x/1e3,y/1e3,diff),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('v-v_LAS (m.a^(-1)) around LASSITER.'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);
colormap(jet)
caxis([-500 500]);
colorbar
set(gca,'Tag','ActiveAxes')
end

function plot_diff_vel_LAS(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations_LAS'];
eval(aa)

u=u*yts;
v=v*yts;
vel=sqrt(u.^2+v.^2);
vel_LAS=sqrt(u_LAS.^2+v_LAS.^2);
%pos=find(vel_LAS==0);
%vel_LAS(pos)=NaN;


diff2=abs(vel-vel_LAS);
pos=find(diff2<=50);

xmin=-1.09*10^6;
xmax=-960000;
ymin=8.1*10^5;
ymax=9.4*10^5;
diff=vel-vel_LAS;
diff(pos)=NaN;
trisurf(index,x/1e3,y/1e3,diff),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('vel-vel_LAS (m.a^(-1)) around LASSITER.'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);
colormap(jet)
caxis([-500 500]);
colorbar
set(gca,'Tag','ActiveAxes')
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55



function plot_tau1(num,zo,series,range_choice,range);
names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);
if exist==1,


aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
[tau_1 tau_2 teta1 teta2]=tau_principal(tau_xx,tau_yy,tau_xy);
summer=[1;1;1];
colormap(jet)
cla
patch(x(index)'/1e3,y(index)'/1e3,[1; 1; 1]*tau_1'),shading interp,view(2)
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('First component of stress (10^5 Pa.s).'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)
caxis([-6 6]);
colorbar
set(gca,'Tag','ActiveAxes')

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5



function plot_tau2(num,zo,series,range_choice,range);
names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);
if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
[tau_1 tau_2 teta1 teta2]=tau_principal(tau_xx,tau_yy,tau_xy);
colormap(jet)
cla
patch(x(index)'/1e3,y(index)'/1e3,[1; 1; 1]*tau_2'),shading interp,view(2)
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Second component of stress (10^5 Pa.s).'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)
caxis([-6 6]);
colorbar
set(gca,'Tag','ActiveAxes')
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5



function plot_teta1(num,zo,series,range_choice,range);
names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);
if exist==1,

aa=['load ' root directory '/' results '_results'];

eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
[tau_1 tau_2 teta1 teta2]=tau_principal(tau_xx,tau_yy,tau_xy);
colormap(jet)
cla
patch(x(index)'/1e3,y(index)'/1e3,[1; 1; 1]*teta1'),shading interp,view(2)
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Angle of first component of stress (Pa.s).'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

caxis([-pi pi])
colorbar
set(gca,'Tag','ActiveAxes')
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5



function plot_teta2(num,zo,series,range_choice,range);
names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);
if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
[tau_1 tau_2 teta1 teta2]=tau_principal(tau_xx,tau_yy,tau_xy);
colormap(jet)
cla
patch(x(index)'/1e3,y(index)'/1e3,[1; 1; 1]*teta2'),shading interp,view(2)
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Angle of second component of stress (Pa.s).'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

caxis([-pi pi])
colorbar
set(gca,'Tag','ActiveAxes')
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55

function plot_thickbar(num,zo,series,range_choice,range);
names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);
if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
colormap(jet)
cla
patch(x(index)',y(index)',[1; 1; 1]*z_thick_bar'),shading interp,view(2)
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Thickness interpolated on the elements (m).'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

if range_choice==0,
caxis([0 500]);
else
   eval(['caxis(' range ');']);
end



colorbar
set(gca,'Tag','ActiveAxes')
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55

function plot_thick(num,zo,series,range_choice,range);

diff_choice=findobj(gcf,'Tag','Diff_choice');
diff_choice=popupstr(diff_choice);
if strcmp(diff_choice,'no')==1,


names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)

xmin=-1.09*10^6;
xmax=-960000;
ymin=8.1*10^5;
ymax=9.4*10^5;
trisurf(index,x/1e3,y/1e3,z_thick),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Thickness (m)'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);
colormap(jet)
if range_choice==0,
caxis([0 500]);
else
   eval(['caxis(' range ');']);
end

colorbar
set(gca,'Tag','ActiveAxes')
end


else

      diff=findobj(gcf,'Tag','Diff');

      diff_value=popupstr(diff);
      
       
      mesh=findobj(gcf,'Tag','Mesh_choice');
      mesh=popupstr(mesh)
      if strcmp(mesh,'Version')==1,
         mesh=1;
      else
         mesh=0;
      end
      

      

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)
z_thick1=z_thick;
x1=x;
y1=y;
index1=index;
end
names_function(diff_value,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)
z_thick2=z_thick;
x2=x;
y2=y;
index2=index;
end


if mesh==1,
   z_thick2=griddata(x2,y2,z_thick2,x1,y1);
   trisurf(index1,x1/1e3,y1/1e3,z_thick1-z_thick2),shading interp,view(2);
   title(texlabel(['Difference z_thick model #' num2str(num) '- z_thick model #' num2str(diff_value) ' on mesh ' num2str(num)]),'fontname','arial','fontsize',18);
   
else
   z_thick1=griddata(x1,y1,z_thick1,x2,y2);
   trisurf(index2,x2/1e3,y2/1e3,z_thick1-z_thick2),shading interp,view(2);
   title(texlabel(['Difference z_thick model #' num2str(num) '- z_thick model #' num2str(diff_value) ' on mesh ' num2str(diff_value)]),'fontname','arial','fontsize',18);
end


if range_choice==0,
else
   eval(['caxis(' range ');']);
end

colorbar;
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
set(gca,'fontname','arial','fontsize',16)

zoom_choice(zo);
set(gca,'Tag','ActiveAxes')

end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
function plot_rotation_hir(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)
angle=atan2(v_HIR,u_HIR)/pi*180;
trisurf(index,x/1e3,y/1e3,angle),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Observed velocity Vx (m.a^(-1)) around HIR. From RSAT1'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)


zoom_choice(zo);

colormap(jet)
%caxis([-500 500]);
colorbar
set(gca,'Tag','ActiveAxes')
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
function plot_quiver_hir(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)

delta=findobj(gcf,'Tag','Quiver_Sparsity');
delta=str2num(deblank(get(delta,'String')));


flag=1:delta:nods;
quiver(x(flag)/1e3,y(flag)/1e3,u_HIR(flag),v_HIR(flag));




xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Observed velocity Vx (m.a^(-1)) around HIR. From RSAT1'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)
zoom_choice(zo);
colormap(jet)
set(gca,'Tag','ActiveAxes')
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
function plot_quiver_las(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);


if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
eval(['load ' root directory '/' maillage '_observations_LAS']);




delta=findobj(gcf,'Tag','Quiver_Sparsity');
delta=str2num(deblank(get(delta,'String')));


flag=1:delta:nods;
quiver(x(flag)/1e3,y(flag)/1e3,u_LAS(flag),v_LAS(flag));

xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Observed velocity Vx (m.a^(-1)) around LASSITER. From RSAT1'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)


zoom_choice(zo);
colormap(jet)
colorbar
set(gca,'Tag','ActiveAxes')
end





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
function plot_quiver_model(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)



delta=findobj(gcf,'Tag','Quiver_Sparsity');
delta=str2num(deblank(get(delta,'String')));


flag=1:delta:nods;
quiver(x(flag)/1e3,y(flag)/1e3,u(flag),v(flag));

xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Observed velocity Vx (m.a^(-1)) around HIR. From RSAT1'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)


zoom_choice(zo);
colormap(jet)
colorbar
set(gca,'Tag','ActiveAxes')
end






%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
function plot_rotation_model(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
angle=atan2(v,u)/pi*180;
trisurf(index,x/1e3,y/1e3,angle),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Observed velocity Vx (m.a^(-1)) around HIR. From RSAT1'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)


zoom_choice(zo);
colormap(jet)
%caxis([-500 500]);
colorbar
set(gca,'Tag','ActiveAxes')
end







%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
function plot_diff_rotation(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)
angle_model=atan2(v,u)/pi*180;
angle_obs=atan2(v_HIR,u_HIR)/pi*180;
trisurf(index,x/1e3,y/1e3,angle_model-angle_obs),shading interp,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Rotation angle differential. alpha_model-alpha_obs'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)


zoom_choice(zo);
colormap(jet)
caxis([-50 50]);
colorbar

set(gca,'Tag','ActiveAxes')
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
function plot_mesh(num,zo,series,range_choice,range);

names_function(num,series)
load ../data/matlab/commondata/names.mat
load ../data/matlab/commondata/data
exist=exist_by_names([root directory '\' results '_results.mat']);

if exist==1,

aa=['load ' root directory '/' results '_results'];
eval(aa)
aa=['load ' root directory '/' maillage '_datamesh'];
eval(aa)
aa=['load ' root directory '/' maillage '_fem_parameters'];
eval(aa)
aa=['load ' root directory '/' maillage '_observations'];
eval(aa)
u=zeros(nods,1);

trisurf(index,x/1e3,y/1e3,u),shading faceted,view(2);
xlabel('X (km)','fontname','arial','fontsize',16)
ylabel('Y (km)','fontname','arial','fontsize',16)
title(texlabel('Mesh'),'fontname','arial','fontsize',18);
set(gca,'fontname','arial','fontsize',16)


zoom_choice(zo);
set(gca,'Tag','ActiveAxes')
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function names_function(num,series,range_choice,range)
location=find(pwd=='\');
location=location(length(location));
present_directory=pwd;
present_directory=present_directory(location+1:length(present_directory));

root=['..\data\' present_directory '\'];

directory=['RONNE_w' num2str(series)];
rad_maillage='RONNE_w';
rad_results='w';

maillage=[rad_maillage num2str(num) '_mesh'];
results=[rad_results num2str(num)];

save ../data/matlab/commondata/names.mat maillage results directory root

function f=exist_by_names(str);
fid=fopen(str,'r');
if fid==-1,
   f=0;
else
   f=1;
end



function zoom_choice(zo);
xmin=-1.09*10^6;
xmax=-960000;

ymin=8.1*10^5;
ymax=9.4*10^5;
switch zo,
   case 0,
   xmin=-1.5*10^6;
	xmax=-.5*10^6;
	ymin=1*10^5;
	ymax=11*10^5;
   xlim([xmin/1e3 xmax/1e3]);
   ylim([ymin/1e3 ymax/1e3]);
	case 1,
   xmin=-1.09*10^6;
	xmax=-960000;
	ymin=8.1*10^5;
	ymax=9.4*10^5;
   xlim([xmin/1e3 xmax/1e3]);
   ylim([ymin/1e3 ymax/1e3]);
	case 2,
   xmin=-1.46*10^6;
	xmax=-1.32*10^6;
	ymin=5.5*10^5;
	ymax=8.42*10^5;
   xlim([xmin/1e3 xmax/1e3]);

   ylim([ymin/1e3 ymax/1e3]);
	case 3,
   xmin=-1.26*10^6;
	xmax=-9.7*10^5;
	ymin=8.20*10^5;
	ymax=9.40*10^5;
   xlim([xmin/1e3 xmax/1e3]);
   ylim([ymin/1e3 ymax/1e3]);


end
