function [A,numprofiles,numpoints,closed]=addprofile(A,numprofiles,numpoints,closed,prevplot,root);
%ADDPROFILE - add a profile
%
%   this script is used by expmaster as an elementary operation
%   on an ARGUS profile
%
%   Usage:
%      [A,numprofiles,numpoints,closed]=addprofile(A,numprofiles,numpoints,closed,prevplot,root)
		   
	title('click to add a point to the new profile, RETURN to exit','FontSize',14)
	hold on

	loop=1;
	x=[];
	y=[];

	while loop

		[xi,yi] = ginput(1);
					  
		if ~isempty(xi)
			x(end+1,1)=xi;
			y(end+1,1)=yi;

			%plot everything
			undoplots(prevplot);
			if length(x)
				plot(x,y,'-rs','MarkerSize',10);
			end
			plot(x,y,'rs','MarkerSize',10);
			plot(x(end),y(end),'rs','MarkerSize',14);

		else

			%check that the profile is not empty
			if ~isempty(x)
				A(end+1).x=x; 
				A(end).y=y; 
				A(end).name=root; 
				A(end).density=1; 
				numprofiles=numprofiles+1;
				numpoints=numpoints+length(x);
				closed(end+1)=0;
			end

			%get out
			loop=0;
		end
	end
end
