function md=icetransient(md);
%ICETRANSIENT - transient solution
%
%   Usage:
%      md=icetransient(md)

%define global variables
iceglobal

%determine if run is parallel
if strcmpi(md.cluster,'yes'), cluster=1; else cluster=0;end;

%for now, only serial support is in
if cluster,
	error('icetransient error message: parallel support not implemented yet');
end

if strcmpi(md.type,'2d'),
	md=icetransient2d(md);
else
	md=icetransient3d(md);
end
