function md2=deepcopy(md)
%DEEPCOPY - copies a model
%
%   This routine will copy md into md2. If md is being held in an out of core 
%   repository, user will be prompted for a different repository name, and a 
%   copy of the repository, with the new name, will be done.
%
%   Usage:
%      md2=deepcopy(md)

if isempty(md.repository),
	md2=md;
else
	%New repository name?
	new_repository=input(['   input model is held in repository: ' md.repository '. you need a new name for the model copy: ']);
	md2=model(new_repository);

	structfields=fields(md);
	for i=1:length(structfields),
		field=structfields(i);field=field{1};
		if strcmpi(field,'repository'),
			%we don't want to clobber md2.repository!
			continue;
		end
		fieldval=getfield(md,field);
		if isfield(struct(md2),field),
			eval(['md2.' field '=fieldval;']);
		end
	end
end
