function displaybc(md)
%DISPLAYBC - display of the boundary conditions fileds
%
%   to avoid clobbering display.m with every field from model md, 
%   we create this routine that displays boundary conditions  from model md, 
%   only if requested.
%
%   Usage:
%      displaybc(md)

disp(sprintf('   Boundary conditions:'));
disp(sprintf('      diagnostic:'));
disp(sprintf('         gridondirichlet_diag: (%i)',length(md.gridondirichlet_diag)));
disp(sprintf('         dirichletvalues_diag [m/a]: (%i,%i)',length(md.dirichletvalues_diag),2));
disp(sprintf('         segmentonneumann_diag: (%i)',length(md.segmentonneumann_diag)));
disp(sprintf('         neumannvalues_diag [N]: (%i)',length(md.neumannvalues_diag)));

disp(sprintf('      prognostic:'));
disp(sprintf('         gridondirichlet_prog: (%i)',length(md.gridondirichlet_prog)));
disp(sprintf('         dirichletvalues_prog [m/a]: (%i)',length(md.dirichletvalues_prog)));
disp(sprintf('         segmentonneumann_prog (flux): (%i)',length(md.segmentonneumann_prog)));
disp(sprintf('         neumannvalues_prog [N]: (%i)',length(md.neumannvalues_prog)));
disp(sprintf('         segmentonneumann_prog2 (thickness gradient): (%i)',length(md.segmentonneumann_prog2)));
disp(sprintf('         neumannvalues_prog2 [N]: (%i)',length(md.neumannvalues_prog2)));

disp(sprintf('      thermal:'));
disp(sprintf('         gridondirichlet_thermal: (%i)',length(md.gridondirichlet_thermal)));
disp(sprintf('         dirichletvalues_thermal [K]: (%i)',length(md.dirichletvalues_thermal)));
disp(sprintf('         melting [m/a]: (%i)',length(md.melting)));
