/*
 * GradJOrth.c:
 */

#include "../../../config.h"

#if defined(_PARALLEL_) && defined(_HAVE_PETSC_)

#include "../include/cielo.h"
#include "../modules.h"
#include "./parallel.h"

#undef __FUNCT__ 
#define __FUNCT__ "GradJOrth"
#undef CLEANUP
#define CLEANUP GradJOrthLocalCleanup();

void GradJOrthLocalCleanup(void);

int GradJOrth(WorkspaceParams* workspaceparams){
	
	/*Error management: */
	int noerr=1;
	int i;

	Vec* gradient=NULL;
	Vec* gradient2=NULL;
	Vec* oldgradient=NULL;
	Vec* newgradient=NULL;


	for(i=0;i<workspaceparams->num_control_parameters;i++){
		char* control_type=workspaceparams->control_types[i];

		gradient=WorkspaceParamsGetParameterGradient(workspaceparams,control_type);
		oldgradient=WorkspaceParamsGetOldParameterGradient(workspaceparams,control_type);

		Orthx( &newgradient,gradient,oldgradient);

		/*Save oldgradient: */
		gradient2=xmalloc(sizeof(Vec));VecDuplicate(*gradient,gradient2);VecCopy(*gradient,*gradient2); 
		WorkspaceParamsSetOldParameterGradient(workspaceparams,gradient2,control_type);
		
		/*Set new gradient: */
		WorkspaceParamsSetParameterGradient(workspaceparams,newgradient,control_type);
	}


	EXIT(noerr);
}

void GradJOrthLocalCleanup(void){
	return;
}

#endif //#if defined(_PARALLEL_) && defined(_HAVE_PETSC_)

